/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.data.convert.util.pdf;

import com.itextpdf.awt.geom.Rectangle2D;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.xforceplus.tower.data.convert.util.pdf.ReplaceRegion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PositionRenderListener
implements RenderListener {
    private List<String> findText;
    private float defaultH;
    private float fixHeight;
    private Map<String, ReplaceRegion> result = new HashMap<String, ReplaceRegion>();

    public PositionRenderListener(List<String> findText, float defaultH, float fixHeight) {
        this.findText = findText;
        this.defaultH = defaultH;
        this.fixHeight = fixHeight;
    }

    public PositionRenderListener(List<String> findText) {
        this.findText = findText;
        this.defaultH = 12.0f;
        this.fixHeight = 2.0f;
    }

    public void beginTextBlock() {
    }

    public void endTextBlock() {
    }

    public void renderImage(ImageRenderInfo imageInfo) {
    }

    public void renderText(TextRenderInfo textInfo) {
        String text = textInfo.getText();
        for (String keyWord : this.findText) {
            if (null == text || !text.equals(keyWord)) continue;
            Rectangle2D.Float bound = textInfo.getBaseline().getBoundingRectange();
            ReplaceRegion region = new ReplaceRegion(keyWord);
            region.setH(Float.valueOf(bound.height == 0.0f ? this.defaultH : bound.height));
            region.setW(Float.valueOf(bound.width));
            region.setX(Float.valueOf(bound.x));
            region.setY(Float.valueOf(bound.y - this.fixHeight));
            this.result.put(keyWord, region);
        }
    }

    public Map<String, ReplaceRegion> getResult() {
        for (String key : this.findText) {
            if (this.result.get(key) != null) continue;
            this.result.put(key, null);
        }
        return this.result;
    }
}

