/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage;

import com.google.common.collect.Lists;
import com.xforceplus.tower.file.client.model.Response;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import com.xforceplus.tower.storage.service.FileService;
import java.io.InputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StorageFactory {
    @Autowired
    private FileService fileService;

    public Long uploadFile(UploadFileRequest uploadFileRequest) {
        return this.fileService.uploadFile(uploadFileRequest);
    }

    public void downloadFile(HttpServletResponse response, Long userId, Long tenantId, Long fileId, String fileName) {
        this.fileService.downloadFile(response, userId, tenantId, fileId, fileName);
    }

    public String getPublicFileUrl(Long userId, Long tenantId, Long fileId) {
        return this.fileService.getPublicFileUrl(userId, tenantId, fileId);
    }

    public String getThumbnail(Long userId, Long tenantId, Long fileId, int height, int weight) {
        return this.fileService.getThumbnail(userId, tenantId, fileId, height, weight);
    }

    public void downLoadThumbnail(HttpServletResponse response, Long userId, Long tenantId, Long fileId, Integer height, Integer width) {
        this.fileService.downLoadThumbnail(response, userId, tenantId, fileId, height, width);
    }

    public Long uploadByInputStream(UploadFileRequest uploadFileRequest) {
        return this.fileService.uploadByInputStream(uploadFileRequest);
    }

    public InputStream downloadInputStream(Long userId, Long tenantId, Long fileId, String fileName) {
        return this.fileService.downloadInputStream(userId, tenantId, fileId, fileName);
    }

    public Response deleteFile(Long tenantId, Long fileId) {
        return this.fileService.deleteFileRecords(tenantId, Lists.newArrayList((Object[])new Long[]{fileId}));
    }
}

