/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.tower.file.client.apiclient.FileStorageApiClient;
import com.xforceplus.tower.file.client.model.Response;
import com.xforceplus.tower.file.client.model.SignatureResult;
import com.xforceplus.tower.file.client.model.StorageOrig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class FileStorageCacheManger {
    private static final String SIGNATURER_RESULT_CACHE = "SIGNATURER_RESULT_CACHE";
    private static final String SIGNATURER_URL_CACHE = "SIGNATURER_URL_CACHE";
    @Autowired
    private FileStorageApiClient fileStorageApiClient;

    @Cacheable(cacheNames={"SIGNATURER_URL_CACHE"})
    public String getSignatureUrl(Long tenantId, Long id, String storageOrig) {
        Response response = this.fileStorageApiClient.getReadSignature(tenantId, id, Long.valueOf(600L), StorageOrig.getStorageOrig((String)storageOrig));
        return (String)JSONObject.parseObject((String)JSON.toJSONString((Object)response.getResult()), String.class);
    }

    @Cacheable(cacheNames={"SIGNATURER_RESULT_CACHE"})
    public SignatureResult getSignatureResult(Long tenantId, String filePath, String storageOrig) {
        Response response = this.fileStorageApiClient.getWriteSignature(tenantId, filePath, Long.valueOf(600L), StorageOrig.getStorageOrig((String)storageOrig));
        return (SignatureResult)JSONObject.parseObject((String)JSON.toJSONString((Object)response.getResult()), SignatureResult.class);
    }
}

