/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.service;

import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.StorageClass;
import com.xforceplus.tower.file.client.apiclient.FileWaterMarkApiClient;
import com.xforceplus.tower.file.client.model.SignatureResult;
import com.xforceplus.tower.file.client.model.StorageOrig;
import com.xforceplus.tower.file.client.model.WaterMarkStyle;
import com.xforceplus.tower.storage.cache.FileStorageCacheManger;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import com.xforceplus.tower.storage.service.FileWrapper;
import com.xforceplus.tower.storage.utils.CommonTools;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class AliyunOssWrapper
implements FileWrapper {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FileStorageCacheManger fileStorageCacheManger;
    @Autowired
    private FileWaterMarkApiClient fileWaterMarkApiClient;

    @Override
    public void uploadFileBySignature(MultipartFile file, Long tenantId, String filePath, String storageOrig) {
        String objectAcl = CannedAccessControlList.PublicReadWrite.toString();
        if (StorageOrig.OSS_PRIVATE.value().equals(storageOrig)) {
            objectAcl = CannedAccessControlList.Private.toString();
        }
        CloseableHttpClient httpClient = null;
        try {
            SignatureResult signatureResult = this.fileStorageCacheManger.getSignatureResult(tenantId, filePath, storageOrig);
            httpClient = HttpClientBuilder.create().build();
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setBoundary("----WebKitFormBoundaryqnvIfU1fo0mWUXaT");
            multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            multipartEntityBuilder.addPart("x-oss-storage-class", (ContentBody)new StringBody(StorageClass.Standard.name(), ContentType.MULTIPART_FORM_DATA));
            multipartEntityBuilder.addPart("x-oss-object-acl", (ContentBody)new StringBody(objectAcl, ContentType.MULTIPART_FORM_DATA));
            multipartEntityBuilder.addPart("name", (ContentBody)new StringBody(file.getName(), ContentType.MULTIPART_FORM_DATA));
            multipartEntityBuilder.addPart("key", (ContentBody)new StringBody(signatureResult.getFilePath(), ContentType.MULTIPART_FORM_DATA));
            multipartEntityBuilder.addPart("policy", (ContentBody)new StringBody(signatureResult.getEncodePolicy(), ContentType.MULTIPART_FORM_DATA));
            multipartEntityBuilder.addPart("OSSAccessKeyId", (ContentBody)new StringBody(signatureResult.getoSSAccessKeyId(), ContentType.MULTIPART_FORM_DATA));
            multipartEntityBuilder.addPart("success_action_status", (ContentBody)new StringBody("200", ContentType.MULTIPART_FORM_DATA));
            multipartEntityBuilder.addPart("signature", (ContentBody)new StringBody(signatureResult.getSignature(), ContentType.MULTIPART_FORM_DATA));
            multipartEntityBuilder.addBinaryBody("file", file.getInputStream());
            HttpPost httpPost = new HttpPost(signatureResult.getUrlStr());
            httpPost.setEntity(multipartEntityBuilder.build());
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            this.logger.info("httpResponse :{}", (Object)httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new IOException("upload file fail");
            }
        }
        catch (IOException e) {
            this.logger.error("uploadFileBySignature file error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    this.logger.error("httpclient close error ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public InputStream inputStreamBySignatureUrl(Long tenantId, Long id, String storageType) {
        String urlStr = this.fileStorageCacheManger.getSignatureUrl(tenantId, id, storageType);
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            return conn.getInputStream();
        }
        catch (IOException e) {
            this.logger.error("inputStreamBySignatureUrl file error:{}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getThumbnailUrl(String url, int height, int width) {
        return url + "?x-oss-process=image/resize,m_fill,h_" + height + ",w_" + width + ",limit_0";
    }

    @Override
    public void generateWaterMark(UploadFileRequest uploadFileRequest, Long fileId, StorageOrig storageOrig) {
        Long tenantId = uploadFileRequest.getTenantId();
        if (uploadFileRequest.getWaterMarkRequest() == null) {
            return;
        }
        String style = CommonTools.getWaterMarkStyle(uploadFileRequest.getWaterMarkRequest());
        if (CommonTools.isEmpty(style)) {
            return;
        }
        WaterMarkStyle waterMarkStyle = new WaterMarkStyle();
        waterMarkStyle.setStyle(style);
        waterMarkStyle.setStorageOrig(storageOrig.value());
        this.fileWaterMarkApiClient.generateWatermark(tenantId, fileId, waterMarkStyle);
    }
}

