/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.xforceplus.tower.file.client.apiclient.FileRecordApiClient;
import com.xforceplus.tower.file.client.apiclient.FileUserRelApiClient;
import com.xforceplus.tower.file.client.model.FileChannel;
import com.xforceplus.tower.file.client.model.FileRecord;
import com.xforceplus.tower.file.client.model.FileUserRelEntity;
import com.xforceplus.tower.file.client.model.Response;
import com.xforceplus.tower.file.client.model.StorageOrig;
import com.xforceplus.tower.file.client.model.StorageType;
import com.xforceplus.tower.storage.model.PriviledgeRequest;
import com.xforceplus.tower.storage.model.PriviledgeType;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import com.xforceplus.tower.storage.service.AliyunOssWrapper;
import com.xforceplus.tower.storage.service.FileWrapper;
import com.xforceplus.tower.storage.service.MinioWrapper;
import com.xforceplus.tower.storage.utils.CommonTools;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FileRecordApiClient fileRecordApiClient;
    @Autowired
    private FileWrapper[] fileWrappers;
    @Autowired
    private FileUserRelApiClient fileUserRelApiClient;

    public FileRecord getFileRecord(Long userId, Long tenantId, Long fileId) {
        Response response = this.fileRecordApiClient.fileLists(tenantId, null, null, null, (List)Lists.newArrayList((Object[])new Long[]{fileId}), Integer.valueOf(1), Integer.valueOf(1));
        if (response == null || response.getCode().equals("STORAGEFILE0500")) {
            throw new RuntimeException("\u83b7\u53d6\u6587\u4ef6\u8bb0\u5f55\u5931\u8d25");
        }
        List fileRecordList = JSONObject.parseArray((String)JSON.toJSONString((Object)response.getResult()), FileRecord.class);
        if (CollectionUtils.isEmpty((Collection)fileRecordList)) {
            throw new RuntimeException("\u83b7\u53d6\u6587\u4ef6\u8bb0\u5f55\u5931\u8d25");
        }
        return (FileRecord)fileRecordList.get(0);
    }

    public FileWrapper currentFileServer(FileChannel channel) {
        FileWrapper current = null;
        for (FileWrapper fileWrapper : this.fileWrappers) {
            if (fileWrapper instanceof AliyunOssWrapper && FileChannel.OSS.equals((Object)channel)) {
                current = fileWrapper;
                break;
            }
            if (!(fileWrapper instanceof MinioWrapper) || !FileChannel.MINIO.equals((Object)channel)) continue;
            current = fileWrapper;
            break;
        }
        if (current == null) {
            throw new RuntimeException(String.format("get support file channel error, current channel config {}", channel));
        }
        return current;
    }

    public InputStream getInputStreamByUrl(String urlStr) {
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setRequestMethod("GET");
            return conn.getInputStream();
        }
        catch (IOException e) {
            this.logger.error("inputStreamBySignatureUrl file error:{}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<Long> recordFile(UploadFileRequest uploadFileRequest, StorageOrig storageOrig, String filePath) {
        Long tenantId = uploadFileRequest.getTenantId();
        String appId = uploadFileRequest.getAppId();
        Integer expires = uploadFileRequest.getExpires();
        Long userId = uploadFileRequest.getUserId();
        MultipartFile file = uploadFileRequest.getFile();
        String originalFilename = file.getOriginalFilename();
        FileRecord fileRecord = new FileRecord();
        fileRecord.setUrl(filePath);
        fileRecord.setAppId(appId);
        fileRecord.setExpiresDate(String.valueOf(expires));
        fileRecord.setFileOriginName(originalFilename);
        fileRecord.setFileSize(CommonTools.getPrintSize(file.getSize()));
        fileRecord.setFileType(CommonTools.getExtension(originalFilename));
        fileRecord.setStorageOrig(storageOrig.value());
        fileRecord.setStorageType(StorageType.Standard.type());
        fileRecord.setUserId(userId);
        Response filesResponse = this.fileRecordApiClient.files(tenantId, fileRecord);
        List fileIds = JSONObject.parseArray((String)JSON.toJSONString((Object)filesResponse.getResult()), Long.class);
        return fileIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInputStream byteToFileInputStream(byte[] bytes, String fileName) {
        File file = new File(fileName);
        FileInputStream fileInputStream = null;
        FileOutputStream output = null;
        FilterOutputStream bufferedOutput = null;
        try {
            output = new FileOutputStream(file);
            bufferedOutput = new BufferedOutputStream(output);
            bufferedOutput.write(bytes);
            FileInputStream fileInputStream2 = fileInputStream = new FileInputStream(file);
            return fileInputStream2;
        }
        catch (FileNotFoundException e) {
            this.logger.error("error :", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("error :", (Throwable)e);
        }
        finally {
            if (bufferedOutput != null) {
                try {
                    bufferedOutput.close();
                }
                catch (IOException e) {
                    this.logger.error("error :", (Throwable)e);
                }
            }
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException e) {
                    this.logger.error("error :", (Throwable)e);
                }
            }
        }
        return fileInputStream;
    }

    public byte[] toByteArray(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public void generateUserRel(Long tenantId, Long fileId, Long userId, List<PriviledgeRequest> priviledgeRequests) {
        if (!CommonTools.isEmpty(priviledgeRequests)) {
            for (int i = 0; i < priviledgeRequests.size(); ++i) {
                PriviledgeRequest priviledgeRequest = priviledgeRequests.get(i);
                if (!PriviledgeType.USER.equals((Object)priviledgeRequest.getPriviledgeType()) || CommonTools.isEmpty(priviledgeRequest.getId())) continue;
                FileUserRelEntity entity = new FileUserRelEntity();
                entity.setUserId(userId);
                entity.setUserIds(priviledgeRequest.getId());
                this.fileUserRelApiClient.priviledge(tenantId, fileId, entity);
            }
        }
    }
}

