/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.client;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class GatewayClient {
    private static final Logger logger = LoggerFactory.getLogger(GatewayClient.class);
    private String gateWayDomain;
    private String clientId;
    private String secret;
    private final Token token = new Token();
    public final String GET_TOKEN_PATH = "/api/client/login";

    @Autowired
    public GatewayClient(@Value(value="${tower.gateway.domain:http://paas-t.xforceplus.com}") String gateWayDomain, @Value(value="${tower.gateway.clientId}") String clientId, @Value(value="${tower.gateway.secret}") String secret) {
        if (!StringUtils.hasText((String)clientId) || !StringUtils.hasText((String)secret)) {
            throw new IllegalArgumentException("\u7f51\u5173\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u786e\u8ba4clientId\u8ddfsecret\u5df2\u914d\u7f6e!");
        }
        this.gateWayDomain = gateWayDomain;
        this.clientId = clientId;
        this.secret = secret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken() {
        if (!this.token.hasToken()) {
            GatewayClient gatewayClient = this;
            synchronized (gatewayClient) {
                if (!this.token.hasToken()) {
                    String tokenStr = this.queryTokenFromGateway();
                    this.token.setToken(tokenStr);
                    this.token.setExpireTime(DateTime.now().plusMinutes(15).getMillis());
                }
            }
        }
        return this.token.getToken();
    }

    private String queryTokenFromGateway() {
        try {
            HashMap<String, String> params = new HashMap<String, String>(4);
            params.put("clientId", this.clientId);
            params.put("secret", this.secret);
            HttpResponse httpResponse = ((HttpRequestWithBody)Unirest.post((String)(this.gateWayDomain + "/api/client/login")).header("Content-Type", "application/json")).body(params).asObject(TokenBody.class);
            logger.info("\u8c03\u7528\u7f51\u5173\u83b7\u53d6token, url = {}, clientId = {}, secret = {}, httpResponse = {}", new Object[]{this.gateWayDomain + "/api/client/login", this.clientId, this.secret, JSON.toJSONString((Object)httpResponse)});
            if (!httpResponse.isSuccess()) {
                throw new RuntimeException("\u8c03\u7528\u7f51\u5173\u83b7\u53d6token\u5931\u8d25, msg = " + ((TokenBody)httpResponse.getBody()).toString());
            }
            TokenBody tokenBody = (TokenBody)httpResponse.getBody();
            if (this.isFail(tokenBody)) {
                throw new RuntimeException("\u8c03\u7528\u7f51\u5173\u83b7\u53d6token\u5931\u8d25, msg = " + ((TokenBody)httpResponse.getBody()).toString());
            }
            return tokenBody.getData();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7f51\u5173\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isFail(TokenBody tokenBody) {
        return !"1".equals(tokenBody.getCode());
    }

    class Token {
        private String token;
        private long expireTime;

        Token() {
        }

        String getToken() {
            return this.token;
        }

        void setToken(String token) {
            this.token = token;
        }

        void setExpireTime(long expireTime) {
            this.expireTime = expireTime;
        }

        boolean hasToken() {
            return StringUtils.hasText((String)this.token) && System.currentTimeMillis() < this.expireTime;
        }
    }

    public static class TokenBody {
        private String code;
        private String message;
        private String data;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String toString() {
            return "TokenBody{code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", data='" + this.data + '\'' + '}';
        }
    }
}

