/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.config;

import com.xforceplus.tower.storage.client.GatewayClient;
import kong.unirest.Config;
import kong.unirest.HttpRequest;
import kong.unirest.Interceptor;
import kong.unirest.Unirest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@ComponentScan(value={"com.xforceplus.tower.storage"})
@Configuration
public class StorageConfig {
    @Autowired
    private GatewayClient gatewayClient;
    @Value(value="${tower.http.connectTimeout:1000}")
    private int connectTimeout;
    @Value(value="${tower.http.socketTimeout:3000}")
    private int socketTimeout;

    @Bean
    public Unirest init() {
        Unirest.config().connectTimeout(this.connectTimeout).socketTimeout(this.socketTimeout).verifySsl(false).interceptor(new Interceptor(){

            public void onRequest(HttpRequest<?> request, Config config) {
                if (!request.getUrl().contains(((StorageConfig)StorageConfig.this).gatewayClient.GET_TOKEN_PATH)) {
                    request.header("x-app-token", StorageConfig.this.gatewayClient.getToken());
                }
            }
        });
        return null;
    }
}

