/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.utils;

import com.xforceplus.tower.file.client.model.FileChannel;
import com.xforceplus.tower.file.client.model.Policy;
import com.xforceplus.tower.storage.constant.FileExtension;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import com.xforceplus.tower.storage.model.WaterMarkRequest;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.springframework.web.multipart.MultipartFile;

public class CommonTools {
    public static String getPrintSize(long size) {
        long rest = 0L;
        if (size < 1024L) {
            return String.valueOf(size) + "B";
        }
        if ((size /= 1024L) < 1024L) {
            return String.valueOf(size) + "KB";
        }
        rest = size % 1024L;
        if ((size /= 1024L) < 1024L) {
            return String.valueOf((size *= 100L) / 100L) + "." + String.valueOf(rest * 100L / 1024L % 100L) + "MB";
        }
        size = size * 100L / 1024L;
        return String.valueOf(size / 100L) + "." + String.valueOf(size % 100L) + "GB";
    }

    public static String getExtension(String fileName) {
        String[] fileArray = fileName.split("\\.");
        String extension = ".";
        if (fileArray.length > 1) {
            extension = extension + fileArray[fileArray.length - 1];
        }
        return extension;
    }

    public static String getWaterMarkStyle(WaterMarkRequest waterMarkRequest) {
        if (waterMarkRequest == null) {
            return "";
        }
        StringBuilder style = new StringBuilder("image/watermark,text_");
        Base64.Encoder encoder = Base64.getEncoder();
        String textBase64 = encoder.encodeToString(waterMarkRequest.getTextWaterMark().getBytes());
        style.append(textBase64);
        if (waterMarkRequest.getType() != null) {
            style.append(",").append("type_").append(waterMarkRequest.getType().base64());
        }
        if (waterMarkRequest.getColor() != null) {
            style.append(",").append("color_").append(waterMarkRequest.getColor());
        }
        if (waterMarkRequest.getSize() != null) {
            style.append(",").append("size_").append(waterMarkRequest.getSize());
        }
        if (waterMarkRequest.getShadow() != null) {
            style.append(",").append("shadow_").append(waterMarkRequest.getShadow());
        }
        if (waterMarkRequest.getRotate() != null) {
            style.append(",").append("rotate_").append(waterMarkRequest.getRotate());
        }
        if (waterMarkRequest.getFill() != null) {
            style.append(",").append("fill_").append(waterMarkRequest.getFill());
        }
        return style.toString();
    }

    public static void checkUploadFileRequest(UploadFileRequest uploadFileRequest, FileChannel fileChannel) {
        Long tenantId = uploadFileRequest.getTenantId();
        Policy policy = uploadFileRequest.getPolicy();
        String filePath = uploadFileRequest.getFilePath();
        Objects.requireNonNull(uploadFileRequest, "uploadFileRequest can not null");
        Objects.requireNonNull(tenantId, "tenantId can not null");
        Objects.requireNonNull(policy, "policy can not null");
        Objects.requireNonNull(uploadFileRequest.getAppId(), "appId can not null");
        Objects.requireNonNull(uploadFileRequest.getUserId(), "userId can not null");
        Objects.requireNonNull(uploadFileRequest.getOverwrite(), "overwrite can not null");
        Objects.requireNonNull(uploadFileRequest.getExpires(), "wxpires can not null");
        Objects.requireNonNull(filePath, "filePath can not null");
        MultipartFile file = Objects.requireNonNull(uploadFileRequest.getFile(), "file can not null");
        String originalFilename = file.getOriginalFilename();
        Objects.requireNonNull(originalFilename, "originalFilename can not null");
        if (uploadFileRequest.getWaterMarkRequest() != null) {
            String extension = CommonTools.getExtension(originalFilename);
            if (!(FileExtension.JPG.value().equals(extension) || FileExtension.PNG.value().equals(extension) || FileExtension.WEBP.value().equals(extension))) {
                throw new RuntimeException("\u56fe\u7247\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u751f\u6210\u6c34\u5370");
            }
        }
        if (FileChannel.MINIO.equals((Object)fileChannel)) {
            if (uploadFileRequest.getWaterMarkRequest() != null) {
                throw new RuntimeException("\u4f7f\u7528minio\u65f6 \u4e0d\u652f\u6301\u6c34\u5370\u529f\u80fd");
            }
            if (!uploadFileRequest.getOverwrite().booleanValue()) {
                throw new RuntimeException("\u4f7f\u7528minio\u65f6 overwrite \u5fc5\u987b\u4e3atrue");
            }
        }
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1, filePath.length());
        }
        if (filePath.endsWith("/")) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        filePath = (policy.value() + "/" + String.valueOf(tenantId) + "/" + filePath + "/" + originalFilename).replace("//", "/");
        uploadFileRequest.setFilePath(filePath);
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        if (str.trim().length() == 0) {
            return true;
        }
        return "null".equalsIgnoreCase(str.trim());
    }

    public static boolean isEmpty(List list) {
        if (list == null) {
            return true;
        }
        return list.size() == 0;
    }
}

