/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;

public class SnowflakeUtil {
    private static final long TWEPOCH = 1559296757000L;
    private static final long WORKER_ID = SnowflakeUtil.getWorkerId();
    private static final long DATA_CENTER_ID = SnowflakeUtil.getDataCenterId();
    private static final long WORKER_ID_BITS = 8L;
    private static final long DATA_CENTER_ID_BITS = 2L;
    private static final long MAX_WORKER_ID = 255L;
    private static final long MAX_DATA_CENTER_ID = 3L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 20L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private static long sequence = 0L;
    private static long lastTimestamp = -1L;

    public static synchronized long nextId() {
        if (WORKER_ID > 255L || WORKER_ID < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 255L));
        }
        if (DATA_CENTER_ID > 3L || DATA_CENTER_ID < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 3L));
        }
        long timestamp = System.currentTimeMillis();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                timestamp = SnowflakeUtil.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - 1559296757000L << 22 | DATA_CENTER_ID << 20 | WORKER_ID << 12 | sequence;
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    public static Long getWorkerId() {
        try {
            return Long.parseLong(StringUtils.substringAfterLast((String)InetAddress.getLocalHost().getHostAddress(), (String)"."));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static Long getDataCenterId() {
        return (long)(Math.random() * 3.0 + 1.0);
    }
}

