/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.tower.storage.client.GatewayClient;
import java.lang.reflect.Type;
import kong.unirest.Config;
import kong.unirest.GenericType;
import kong.unirest.HttpRequest;
import kong.unirest.Interceptor;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@ComponentScan(value={"com.xforceplus.tower.storage"})
@Configuration
public class StorageConfig {
    @Autowired
    private GatewayClient gatewayClient;
    @Value(value="${tower.http.connectTimeout:1000}")
    private int connectTimeout;
    @Value(value="${tower.http.socketTimeout:3000}")
    private int socketTimeout;

    @Bean
    public Unirest init() {
        Unirest.config().setObjectMapper(new ObjectMapper(){

            public <T> T readValue(String value, Class<T> valueType) {
                return (T)JSON.parseObject((String)value, valueType);
            }

            public String writeValue(Object value) {
                return JSON.toJSONString((Object)value);
            }

            public <T> T readValue(String value, GenericType<T> genericType) {
                return (T)JSON.parseObject((String)value, (Type)genericType.getType(), (Feature[])new Feature[0]);
            }
        }).connectTimeout(this.connectTimeout).socketTimeout(this.socketTimeout).verifySsl(false).interceptor(new Interceptor(){

            public void onRequest(HttpRequest<?> request, Config config) {
                if (!request.getUrl().contains(((StorageConfig)StorageConfig.this).gatewayClient.GET_TOKEN_PATH)) {
                    request.header("x-app-token", StorageConfig.this.gatewayClient.getToken());
                }
            }
        });
        return null;
    }
}

