/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage;

import com.xforceplus.tower.file.client.model.Policy;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import com.xforceplus.tower.storage.service.FileService;
import com.xforceplus.tower.storage.utils.FilePathUtils;
import com.xforceplus.tower.storage.utils.ImageWatermarkUtil;
import com.xforceplus.tower.storage.utils.ZipUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import org.apache.tools.zip.ZipOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocumentFactory {
    @Autowired
    private FileService fileService;
    private UploadFileRequest uploadFileRequest;

    public String imageQuality(File srcFile, float quality) throws IOException {
        String fileName = FilePathUtils.getFileNameWithoutSuffix(srcFile.getName()) + "_quality_" + quality + FilePathUtils.getFileNameSuffix(srcFile.getName());
        FileOutputStream outputStream = new FileOutputStream(fileName);
        Thumbnails.of((File[])new File[]{srcFile}).scale(1.0).outputQuality(quality).toOutputStream((OutputStream)outputStream);
        ByteArrayInputStream swapStream = new ByteArrayInputStream(outputStream.toString().getBytes());
        Long fileId = this.fileService.uploadByInputStream(this.buildUploadRequest(fileName, swapStream));
        String fileUrl = this.fileService.getPublicFileUrl(0L, 0L, fileId, 0L);
        return fileUrl;
    }

    public String imageResize(File file, int width, int height) throws IOException {
        String fileName = FilePathUtils.getFileNameWithoutSuffix(file.getName()) + "_" + width + "_" + height + FilePathUtils.getFileNameSuffix(file.getName());
        FileOutputStream outputStream = new FileOutputStream(fileName);
        Thumbnails.of((File[])new File[]{file}).size(width, height).toOutputStream((OutputStream)outputStream);
        ByteArrayInputStream swapStream = new ByteArrayInputStream(outputStream.toString().getBytes());
        Long fileId = this.fileService.uploadByInputStream(this.buildUploadRequest(fileName, swapStream));
        String fileUrl = this.fileService.getPublicFileUrl(0L, 0L, fileId, 0L);
        return fileUrl;
    }

    public String imageScale(File file, double scale) throws IOException {
        String fileName = FilePathUtils.getFileNameWithoutSuffix(file.getName()) + "_scale_" + scale + FilePathUtils.getFileNameSuffix(file.getName());
        FileOutputStream outputStream = new FileOutputStream(fileName);
        Thumbnails.of((File[])new File[]{file}).scale(scale).toOutputStream((OutputStream)outputStream);
        ByteArrayInputStream swapStream = new ByteArrayInputStream(outputStream.toString().getBytes());
        Long fileId = this.fileService.uploadByInputStream(this.buildUploadRequest(fileName, swapStream));
        String fileUrl = this.fileService.getPublicFileUrl(0L, 0L, fileId, 0L);
        return fileUrl;
    }

    public String imageWatermark(File file, Position position, BufferedImage imageMark, float opacity) throws IOException {
        String fileName = FilePathUtils.getFileNameWithoutSuffix(file.getName()) + "_mark_" + opacity + FilePathUtils.getFileNameSuffix(file.getName());
        FileOutputStream outputStream = new FileOutputStream(fileName);
        Thumbnails.of((File[])new File[]{file}).watermark(position, imageMark, opacity).toOutputStream((OutputStream)outputStream);
        ByteArrayInputStream swapStream = new ByteArrayInputStream(outputStream.toString().getBytes());
        Long fileId = this.fileService.uploadByInputStream(this.buildUploadRequest(fileName, swapStream));
        String fileUrl = this.fileService.getPublicFileUrl(0L, 0L, fileId, 0L);
        return fileUrl;
    }

    public String imageWatermark(File source, String text, String type) throws IOException {
        BufferedImage image = ImageIO.read(source);
        String fileName = source.getName() + "_mark_" + text;
        FileOutputStream outputStream = new FileOutputStream(fileName);
        int imageType = "png".equalsIgnoreCase(type) ? 2 : 1;
        BufferedImage watermarked = new BufferedImage(image.getWidth(), image.getHeight(), imageType);
        Graphics2D w = (Graphics2D)watermarked.getGraphics();
        w.drawImage((Image)image, 0, 0, null);
        AlphaComposite alphaChannel = AlphaComposite.getInstance(3, 0.4f);
        w.setComposite(alphaChannel);
        w.setColor(Color.RED);
        w.setFont(new Font("SansSerif", 1, 60));
        FontMetrics fontMetrics = w.getFontMetrics();
        Rectangle2D rect = fontMetrics.getStringBounds(text, w);
        int centerX = (image.getWidth() - (int)rect.getWidth()) / 2;
        int centerY = image.getHeight() / 2;
        w.drawString(text, centerX, centerY);
        ImageIO.write((RenderedImage)watermarked, type, outputStream);
        w.dispose();
        ByteArrayInputStream swapStream = new ByteArrayInputStream(outputStream.toString().getBytes());
        Long fileId = this.fileService.uploadByInputStream(this.buildUploadRequest(fileName, swapStream));
        String fileUrl = this.fileService.getPublicFileUrl(0L, 0L, fileId, 0L);
        return fileUrl;
    }

    public String imageWatermark(String logoText, String srcImgPath, String targetPath, Integer degree) {
        ImageWatermarkUtil.imageByText(logoText, srcImgPath, targetPath, degree);
        return targetPath;
    }

    public String filesZip(File ... files) throws Exception {
        List<File> list = Arrays.asList(files);
        String fileName = System.currentTimeMillis() + "";
        FileOutputStream outputStream = new FileOutputStream(fileName);
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)outputStream);
        zipOutputStream.setEncoding("GBK");
        for (File file : list) {
            ZipUtils.compress(file, zipOutputStream, "");
        }
        return fileName;
    }

    public String fileUnzip(String zipFile, String destFile) throws Exception {
        ZipUtils.decompress(zipFile, destFile);
        return "";
    }

    public String encryptFile(String fileName) {
        return null;
    }

    public String decryptFile(String fileName, String key) throws Exception {
        return null;
    }

    private UploadFileRequest buildUploadRequest(String fileName, InputStream inputStream) {
        UploadFileRequest request = new UploadFileRequest();
        request.setTenantId(0L);
        request.setUserId(0L);
        request.setAppId("document_app");
        request.setExpires(0);
        request.setFileName(fileName);
        request.setInputStream(inputStream);
        request.setOverwrite(true);
        request.setPolicy(Policy.PUBLIC_POLICY);
        return request;
    }

    private String expandName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return ext;
    }
}

