/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.service;

import com.xforceplus.tower.file.client.apiclient.FileChannelApiClient;
import com.xforceplus.tower.file.client.apiclient.FileRecordApiClient;
import com.xforceplus.tower.file.client.apiclient.FileStorageApiClient;
import com.xforceplus.tower.file.client.apiclient.FileUserRelApiClient;
import com.xforceplus.tower.file.client.apiclient.FileWaterMarkApiClient;
import com.xforceplus.tower.file.client.model.FileChannel;
import com.xforceplus.tower.file.client.model.FileRecord;
import com.xforceplus.tower.file.client.model.Policy;
import com.xforceplus.tower.file.client.model.RecordEntity;
import com.xforceplus.tower.file.client.model.Response;
import com.xforceplus.tower.file.client.model.StorageOrig;
import com.xforceplus.tower.storage.cache.FileStorageCacheManger;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import com.xforceplus.tower.storage.service.FileWrapper;
import com.xforceplus.tower.storage.utils.CommonTools;
import com.xforceplus.tower.storage.utils.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private FileWrapper[] fileWrappers;
    private FileStorageCacheManger fileStorageCacheManger;
    private FileRecordApiClient fileRecordApiClient;
    private FileStorageApiClient fileStorageApiClient;
    private FileWaterMarkApiClient fileWaterMarkApiClient;
    private FileUserRelApiClient fileUserRelApiClient;
    private FileChannelApiClient fileChannelApiClient;
    private FileUtils fileUtils;

    @Autowired
    public FileService(FileWrapper[] fileWrappers, FileStorageCacheManger fileStorageCacheManger, FileRecordApiClient fileRecordApiClient, FileStorageApiClient fileStorageApiClient, FileWaterMarkApiClient fileWaterMarkApiClient, FileUserRelApiClient fileUserRelApiClient, FileChannelApiClient fileChannelApiClient, FileUtils fileUtils) {
        this.fileWrappers = fileWrappers;
        this.fileStorageCacheManger = fileStorageCacheManger;
        this.fileRecordApiClient = fileRecordApiClient;
        this.fileStorageApiClient = fileStorageApiClient;
        this.fileWaterMarkApiClient = fileWaterMarkApiClient;
        this.fileUserRelApiClient = fileUserRelApiClient;
        this.fileChannelApiClient = fileChannelApiClient;
        this.fileUtils = fileUtils;
    }

    public Long uploadByInputStream(UploadFileRequest uploadFileRequest) {
        try {
            String fileName = uploadFileRequest.getFileName();
            if (StringUtils.isEmpty((CharSequence)fileName)) {
                fileName = "data";
            }
            MockMultipartFile multipartFile = new MockMultipartFile("file", fileName, ContentType.APPLICATION_OCTET_STREAM.toString(), uploadFileRequest.getInputStream());
            uploadFileRequest.setFile((MultipartFile)multipartFile);
        }
        catch (IOException e) {
            this.logger.error("uploadByInputStream request :{}", (Throwable)e);
        }
        return this.uploadFile(uploadFileRequest);
    }

    public Long uploadFile(UploadFileRequest uploadFileRequest) {
        this.logger.info("upload request :{}", (Object)uploadFileRequest.toString());
        Long tenantId = uploadFileRequest.getTenantId();
        String appId = uploadFileRequest.getAppId();
        Response channel = this.fileChannelApiClient.getChannel(tenantId, appId);
        FileChannel fileChannel = (FileChannel)channel.getResult();
        CommonTools.checkUploadFileRequest(uploadFileRequest, fileChannel);
        String filePath = uploadFileRequest.getFilePath();
        try {
            boolean exist;
            StorageOrig storageOrig = Objects.requireNonNull(StorageOrig.from((Policy)uploadFileRequest.getPolicy(), (FileChannel)fileChannel));
            FileWrapper fileWrapper = this.fileUtils.currentFileServer(fileChannel);
            if (!uploadFileRequest.getOverwrite().booleanValue() && (exist = this.fileStorageApiClient.checkFileExsit(tenantId, filePath, storageOrig))) {
                throw new RuntimeException("\u6587\u4ef6\u5df2\u5b58\u5728");
            }
            fileWrapper.uploadFileBySignature(uploadFileRequest.getFile(), tenantId, filePath, storageOrig.value());
            List<Long> fileIds = this.fileUtils.recordFile(uploadFileRequest, storageOrig, filePath);
            this.fileUtils.generateUserRel(tenantId, fileIds.get(0), uploadFileRequest.getUserId(), uploadFileRequest.getPriviledgeRequests());
            fileWrapper.generateWaterMark(uploadFileRequest, fileIds.get(0), storageOrig);
            return fileIds.get(0);
        }
        catch (Exception e) {
            this.logger.error("oss upload file error", (Throwable)e);
            throw new RuntimeException("upload file error, caused by:", e);
        }
    }

    public Response<List<RecordEntity>> fileLists(Long tenantId, String key, String keyPrefix, StorageOrig storageOrig, List<Long> ids, Integer page, Integer row) {
        Response response = this.fileRecordApiClient.fileLists(tenantId, key, keyPrefix, storageOrig, ids, page, row);
        return response;
    }

    public Response deleteFileRecords(Long tenantId, List<Long> fileIds) {
        Response response = this.fileRecordApiClient.fileRecords(tenantId, fileIds);
        return response;
    }

    public String getPublicFileUrl(Long userId, Long tenantId, Long fileId, Long expireTime) {
        FileRecord fileRecord = this.fileUtils.getFileRecord(userId, tenantId, fileId);
        StorageOrig storageOrig = StorageOrig.getStorageOrig((String)fileRecord.getStorageOrig());
        if (null == storageOrig) {
            throw new RuntimeException("download storageOrig is null");
        }
        FileChannel fileChannel = FileChannel.getFileChannel((StorageOrig)storageOrig);
        Policy policy = Policy.getPolicy((StorageOrig)storageOrig);
        if (policy != Policy.PUBLIC_POLICY) {
            throw new RuntimeException("\u975e\u516c\u5171\u6587\u4ef6\u4e0d\u63d0\u4f9burl");
        }
        String urlStr = this.fileStorageCacheManger.getSignatureUrl(tenantId, fileId, storageOrig.value(), expireTime);
        return urlStr;
    }

    public InputStream downloadInputStream(Long userId, Long tenantId, Long fileId, String fileName) {
        Objects.requireNonNull(userId);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(fileId);
        boolean b = this.fileUserRelApiClient.getUserIds(tenantId, fileId, userId);
        if (!b) {
            throw new RuntimeException("current user can not oprate this file.");
        }
        FileRecord fileRecord = this.fileUtils.getFileRecord(userId, tenantId, fileId);
        StorageOrig storageOrig = StorageOrig.getStorageOrig((String)fileRecord.getStorageOrig());
        if (null == storageOrig) {
            throw new RuntimeException("download storageOrig is null");
        }
        FileChannel fileChannel = FileChannel.getFileChannel((StorageOrig)storageOrig);
        Policy policy = Policy.getPolicy((StorageOrig)storageOrig);
        String filePath = fileRecord.getUrl();
        if (filePath != null && filePath.trim().length() != 0) {
            try {
                filePath = URLDecoder.decode(filePath, "UTF-8");
                filePath = URLDecoder.decode(filePath, "UTF-8");
                if (CommonTools.isEmpty(fileName)) {
                    fileName = fileRecord.getFileOriginName();
                }
                if (filePath.startsWith("/")) {
                    filePath = filePath.substring(1);
                }
                Path path = Paths.get(filePath, new String[0]);
                String string = Files.probeContentType(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.fileUtils.currentFileServer(fileChannel).inputStreamBySignatureUrl(tenantId, fileId, storageOrig.value());
        }
        throw new RuntimeException("\u8bf7\u8f93\u5165\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6");
    }

    public void downloadFile(HttpServletResponse response, Long userId, Long tenantId, Long fileId, String fileName) {
        Objects.requireNonNull(response);
        Objects.requireNonNull(userId);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(fileId);
        boolean b = this.fileUserRelApiClient.getUserIds(tenantId, fileId, userId);
        if (!b) {
            throw new RuntimeException("current user can not oprate this file.");
        }
        FileRecord fileRecord = this.fileUtils.getFileRecord(userId, tenantId, fileId);
        StorageOrig storageOrig = StorageOrig.getStorageOrig((String)fileRecord.getStorageOrig());
        if (null == storageOrig) {
            throw new RuntimeException("download storageOrig is null");
        }
        FileChannel fileChannel = FileChannel.getFileChannel((StorageOrig)storageOrig);
        Policy policy = Policy.getPolicy((StorageOrig)storageOrig);
        String filePath = fileRecord.getUrl();
        if (filePath != null && filePath.trim().length() != 0) {
            ServletOutputStream out;
            try {
                filePath = URLDecoder.decode(filePath, "UTF-8");
                filePath = URLDecoder.decode(filePath, "UTF-8");
                if (CommonTools.isEmpty(fileName)) {
                    fileName = fileRecord.getFileOriginName();
                }
                if (filePath.startsWith("/")) {
                    filePath = filePath.substring(1);
                }
                Path path = Paths.get(filePath, new String[0]);
                String contentType = Files.probeContentType(path);
                response.setHeader("Content-Disposition", String.format("attachment;filename*=utf-8'zh_cn'%s", URLEncoder.encode(fileName, "utf-8")));
                response.setContentType(contentType);
                out = response.getOutputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            InputStream in = this.fileUtils.currentFileServer(fileChannel).inputStreamBySignatureUrl(tenantId, fileId, storageOrig.value());
            byte[] bufs = new byte[10240];
            try {
                int read;
                while ((read = in.read(bufs, 0, 10240)) != -1) {
                    out.write(bufs, 0, read);
                }
            }
            catch (IOException e) {
                this.logger.error("\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Object)filePath, (Object)e);
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        throw new RuntimeException("\u8bf7\u8f93\u5165\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6");
    }

    public String getThumbnail(Long userId, Long tenantId, Long fileId, int height, int weight) {
        try {
            FileRecord fileRecord = this.fileUtils.getFileRecord(userId, tenantId, fileId);
            String filePath = fileRecord.getUrl();
            String contentType = "";
            if (filePath != null && filePath.trim().length() != 0) {
                Path path = Paths.get(filePath, new String[0]);
                contentType = Files.probeContentType(path);
            }
            if (!contentType.startsWith("image")) {
                throw new RuntimeException("\u975e\u56fe\u7247\u6587\u4ef6\u4e0d\u652f\u6301\u7f29\u7565\u56fe");
            }
            StorageOrig storageOrig = StorageOrig.getStorageOrig((String)fileRecord.getStorageOrig());
            if (null == storageOrig) {
                throw new RuntimeException("download storageOrig is null");
            }
            FileChannel fileChannel = FileChannel.getFileChannel((StorageOrig)storageOrig);
            Policy policy = Policy.getPolicy((StorageOrig)storageOrig);
            if (policy != Policy.PUBLIC_POLICY) {
                throw new RuntimeException("\u975e\u516c\u5171\u6587\u4ef6\u4e0d\u652f\u6301\u83b7\u53d6\u7f29\u7565\u56feurl,\u8bf7\u4e0b\u8f7d");
            }
            String url = this.getPublicFileUrl(userId, tenantId, fileId, 0L);
            return this.fileUtils.currentFileServer(fileChannel).getThumbnailUrl(url, height, weight);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void downLoadThumbnail(HttpServletResponse response, Long userId, Long tenantId, Long fileId, Integer height, Integer width) {
        String thumbnailUrl = "";
        try {
            StorageOrig storageOrig;
            FileRecord fileRecord = this.fileUtils.getFileRecord(userId, tenantId, fileId);
            String filePath = fileRecord.getUrl();
            String contentType = "";
            if (filePath != null && filePath.trim().length() != 0) {
                Path path = Paths.get(filePath, new String[0]);
                contentType = Files.probeContentType(path);
            }
            if (null == (storageOrig = StorageOrig.getStorageOrig((String)fileRecord.getStorageOrig()))) {
                throw new RuntimeException("download storageOrig is null");
            }
            FileChannel fileChannel = FileChannel.getFileChannel((StorageOrig)storageOrig);
            Policy policy = Policy.getPolicy((StorageOrig)storageOrig);
            if (policy == Policy.PUBLIC_POLICY) {
                String url = this.getPublicFileUrl(userId, tenantId, fileId, 0L);
                thumbnailUrl = this.fileUtils.currentFileServer(fileChannel).getThumbnailUrl(url, height, width);
            } else {
                thumbnailUrl = (String)this.fileStorageApiClient.getThumbnail(tenantId, fileId, height, width).getResult();
            }
            response.setHeader("Content-Disposition", String.format("attachment;filename*=utf-8'zh_cn'%s", URLEncoder.encode("thumb- " + fileRecord.getFileOriginName(), "utf-8")));
            response.setContentType(contentType);
        }
        catch (IOException e) {
            this.logger.error("\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        byte[] bufs = new byte[10240];
        try (InputStream in = this.fileUtils.getInputStreamByUrl(thumbnailUrl);
             ServletOutputStream out = response.getOutputStream();){
            int read;
            while ((read = in.read(bufs, 0, 10240)) != -1) {
                out.write(bufs, 0, read);
            }
        }
        catch (IOException e) {
            this.logger.error("\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

