/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.strategys;

import com.alibaba.fastjson.JSON;
import com.xforceplus.tower.storage.entity.BaseParams;
import com.xforceplus.tower.storage.strategys.DocChange;
import com.xforceplus.tower.storage.utils.OssUtil;
import com.xforceplus.tower.storage.utils.PagesUtils;
import com.xforceplus.tower.storage.utils.PdfToImgs;
import com.xforceplus.tower.storage.utils.UploadThread;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class Pdf2imgStrategyImpl
implements DocChange<BaseParams> {
    private static final Logger logger = LoggerFactory.getLogger(Pdf2imgStrategyImpl.class);
    @Value(value="${doc.convert.imgspath}")
    private String imgpath;
    @Autowired
    private OssUtil ossUtil;

    @Override
    public String doJob(BaseParams baseParams) {
        List<String> paths = PdfToImgs.pdf2imgs(baseParams.getFilepath(), this.imgpath);
        List<String> ossPaths = PagesUtils.getPaths("test", paths.size());
        long start = System.currentTimeMillis();
        CountDownLatch countDownLatch = new CountDownLatch(3);
        for (int i = 0; i < 3; ++i) {
            UploadThread thread;
            int end;
            int begin = i * PagesUtils.getPageCount(paths.size());
            if (begin >= (end = (i + 1) * PagesUtils.getPageCount(paths.size()))) {
                end = begin;
            }
            if (i == 2) {
                thread = new UploadThread(this.ossUtil, paths, ossPaths, begin, paths.size(), countDownLatch);
                thread.start();
                continue;
            }
            thread = new UploadThread(this.ossUtil, paths, ossPaths, begin, end, countDownLatch);
            thread.start();
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        logger.info("\u6587\u4ef6\u4e0a\u4f20\u8017\u65f6" + (double)(end - start) / 1000.0 + "\u79d2");
        return JSON.toJSONString(ossPaths);
    }
}

