/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import org.icepdf.core.pobjects.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertThrad
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ConvertThrad.class);
    private CountDownLatch countDownLatch;
    private Document document;
    private int beginNumber;
    private int endNumber;
    private List<String> paths;

    public ConvertThrad(CountDownLatch countDownLatch, Document document, List<String> paths, int beginNumber, int endNumber) {
        this.countDownLatch = countDownLatch;
        this.document = document;
        this.beginNumber = beginNumber;
        this.endNumber = endNumber;
        this.paths = paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info(this.getName() + "\u5b50\u7ebf\u7a0b\u5f00\u59cb");
        BufferedImage image = null;
        float scale = 2.0f;
        float rotation = 0.0f;
        try {
            for (int i = this.beginNumber; i < this.endNumber; ++i) {
                logger.info(this.getName() + "\u5f00\u59cb\u8f6c\u6362\u7b2c" + i + "\u9875\u56fe\u7247");
                BufferedImage rendImage = image = (BufferedImage)this.document.getPageImage(i, 1, 2, rotation, scale);
                String path = this.paths.get(i);
                File file = new File(path);
                ImageIO.write((RenderedImage)rendImage, "png", file);
                image.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.document.dispose();
            logger.info(this.getName() + "\u5b50\u7ebf\u7a0b\u7ed3\u675f");
            this.countDownLatch.countDown();
        }
    }
}

