/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.utils;

import com.aspose.cells.License;
import com.aspose.cells.Workbook;
import com.aspose.words.Document;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.aspectj.weaver.ast.Test;
import org.springframework.stereotype.Component;

@Component
public class FileChangeUtils {
    public static boolean getLicense() {
        boolean result = false;
        try {
            InputStream is = Test.class.getClassLoader().getResourceAsStream("license.xml");
            com.aspose.words.License aposeLic = new com.aspose.words.License();
            aposeLic.setLicense(is);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean getCellLicense() {
        boolean result = false;
        try {
            InputStream is = Test.class.getClassLoader().getResourceAsStream("license.xml");
            License cellLicense = new License();
            cellLicense.setLicense(is);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void doc2pdf(String pdfPath, String wordPath) {
        if (!FileChangeUtils.getLicense()) {
            System.out.println("com.aspose.words lic ERROR!");
            return;
        }
        try {
            long old = System.currentTimeMillis();
            File file = new File(pdfPath);
            FileOutputStream os = new FileOutputStream(file);
            Document doc = new Document(wordPath);
            doc.save((OutputStream)os, 40);
            long now = System.currentTimeMillis();
            System.out.println("\u5171\u8017\u65f6\uff1a" + (double)(now - old) / 1000.0 + "\u79d2");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void excel2pdf(String pdfPath, String excelPath) throws Exception {
        if (!FileChangeUtils.getCellLicense()) {
            return;
        }
        try {
            long old = System.currentTimeMillis();
            Workbook wb = new Workbook((InputStream)new FileInputStream(excelPath));
            File file = new File(pdfPath);
            FileOutputStream fileOS = new FileOutputStream(file);
            wb.save((OutputStream)fileOS, 13);
            long now = System.currentTimeMillis();
            System.out.println("\u5171\u8017\u65f6\uff1a" + (double)(now - old) / 1000.0 + "\u79d2\n\n\u6587\u4ef6\u4fdd\u5b58\u5728:" + file.getPath());
        }
        catch (Exception e) {
            throw new Exception("convert excel to pdf failed ." + e.toString());
        }
    }

    public void word2img(String imgPath, String wordPath) {
        if (!FileChangeUtils.getLicense()) {
            System.out.println("com.aspose.words lic ERROR!");
            return;
        }
    }
}

