/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Random;

public class FileUtil {
    public static String randomFileName() {
        return System.currentTimeMillis() + "" + (new Random().nextInt(9999) + 1000) + "";
    }

    public static String randomFileName(String suffix) {
        return System.currentTimeMillis() + "" + (new Random().nextInt(9999) + 1000) + "." + suffix;
    }

    public static void isExists(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    public static String getFileName(String path) {
        File file = new File(path.trim());
        return file.getName();
    }

    public static String getFileNameWithoutSuffix(String path) {
        File file = new File(path);
        String file_name = file.getName();
        return file_name.substring(0, file_name.lastIndexOf("."));
    }

    public static String getFileSuffix(String path) {
        File file = new File(path);
        String fileName = file.getName();
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static String getFileSuffixWithDone(String path) {
        File file = new File(path);
        String fileName = file.getName();
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public static Long getFileSize(String path) {
        File file = new File(path);
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileChannelCopy(String sourcePath, String expectPath) {
        FileInputStream fi = null;
        FileOutputStream fo = null;
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            fi = new FileInputStream(new File(sourcePath));
            fo = new FileOutputStream(new File(expectPath));
            in = fi.getChannel();
            out = fo.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fi.close();
                in.close();
                fo.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

