/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImageWatermarkUtil {
    private static float alpha = 0.5f;
    public static final int FONT_SIZE = 28;
    private static Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 28);
    private static Color color = Color.RED;
    private static final int X_MOVE = 80;
    private static final int Y_MOVE = 80;

    private static int getTextLength(String text) {
        int length = text.length();
        for (int i = 0; i < text.length(); ++i) {
            String s = String.valueOf(text.charAt(i));
            if (s.getBytes().length <= 1) continue;
            ++length;
        }
        length = length % 2 == 0 ? length / 2 : length / 2 + 1;
        return length;
    }

    public static void imageByText(String logoText, String srcImgPath, String targerPath) {
        ImageWatermarkUtil.imageByText(logoText, srcImgPath, targerPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void imageByText(String logoText, String srcImgPath, String targetImgPath, Integer degree) {
        InputStream is = null;
        OutputStream os = null;
        try {
            BufferedImage srcImg = null;
            if (srcImgPath.contains("http://") || srcImgPath.contains("https://")) {
                URL url = new URL(srcImgPath);
                srcImg = ImageIO.read(url);
            } else {
                File srcFile = new File(srcImgPath);
                System.out.println("srcFileName:" + srcFile.getName());
                srcImg = ImageIO.read(srcFile);
            }
            int width = ((Image)srcImg).getWidth(null);
            int height = ((Image)srcImg).getHeight(null);
            BufferedImage buffImg = new BufferedImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 1);
            Graphics2D g = buffImg.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(srcImg.getScaledInstance(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 4), 0, 0, null);
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), (double)buffImg.getWidth() / 2.0, (double)buffImg.getHeight() / 2.0);
            }
            g.setColor(color);
            g.setFont(font);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            int x = -width / 2;
            int y = -height / 2;
            int markWidth = 28 * ImageWatermarkUtil.getTextLength(logoText);
            int markHeight = 28;
            while ((double)x < (double)width * 1.5) {
                y = -height / 2;
                while ((double)y < (double)height * 1.5) {
                    g.drawString(logoText, x, y);
                    y += markHeight + 80;
                }
                x += markWidth + 80;
            }
            g.dispose();
            os = new FileOutputStream(targetImgPath);
            ImageIO.write((RenderedImage)buffImg, "JPG", os);
            System.out.println("\u6dfb\u52a0\u6c34\u5370\u6587\u5b57\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

