/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.utils;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GetObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OssUtil {
    @Value(value="${aliyun.oss.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${aliyun.oss.endpoint}")
    private String endpoint;
    @Value(value="${aliyun.oss.bucket}")
    private String bucket;
    private static final Logger logger = LoggerFactory.getLogger(OssUtil.class);
    private OSSClient ossClient = null;

    private void connect() {
        this.ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(File file, String key) {
        if (this.ossClient == null) {
            this.connect();
        }
        try {
            this.ossClient.putObject(this.bucket, key, file);
        }
        catch (ClientException e) {
            logger.error("aliyun oss upload local file error: " + e.getErrorMessage());
        }
        return "http://" + this.bucket + "." + this.endpoint + "/" + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadManyFile(Map<String, File> map) {
        if (this.ossClient == null) {
            this.connect();
        }
        try {
            for (String key : map.keySet()) {
                this.ossClient.putObject(this.bucket, key, map.get(key));
            }
        }
        catch (ClientException e) {
            logger.error("aliyun oss upload many local file error: " + e.getErrorMessage());
        }
        finally {
            this.ossClient.shutdown();
            this.ossClient = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String download(File file, String key) {
        if (this.ossClient == null) {
            this.connect();
        }
        try {
            this.ossClient.getObject(new GetObjectRequest(this.bucket, key), file);
        }
        catch (ClientException e) {
            logger.error("aliyun oss download file  error: " + e.getErrorMessage());
        }
        finally {
            this.ossClient.shutdown();
            this.ossClient = null;
        }
        return file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(InputStream inputStream, String key) {
        if (this.ossClient == null) {
            this.connect();
        }
        try {
            this.ossClient.putObject(this.bucket, key, inputStream);
        }
        catch (ClientException e) {
            logger.error("aliyun oss upload file Stream  error: " + e.getErrorMessage());
        }
        finally {
            this.ossClient.shutdown();
            this.ossClient = null;
        }
        return "http://" + this.bucket + "." + this.endpoint + "/" + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(byte[] bytes, String key) {
        if (this.ossClient == null) {
            this.connect();
        }
        try {
            this.ossClient.putObject(this.bucket, key, (InputStream)new ByteArrayInputStream(bytes));
        }
        catch (ClientException e) {
            logger.error("aliyun oss upload file byte[]  error: " + e.getErrorMessage());
        }
        finally {
            this.ossClient.shutdown();
            this.ossClient = null;
        }
        return "http://" + this.bucket + "." + this.endpoint + "/" + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String key) {
        if (this.ossClient == null) {
            this.connect();
        }
        try {
            this.ossClient.deleteObject(this.bucket, key);
        }
        catch (ClientException e) {
            logger.error("aliyun oss delete file error: " + e.getErrorMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.ossClient.shutdown();
            this.ossClient = null;
        }
        return true;
    }
}

