/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.utils;

import com.xforceplus.tower.storage.utils.ConvertThrad;
import com.xforceplus.tower.storage.utils.OssUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ConvertThrad.class);
    private CountDownLatch countDownLatch;
    private List<String> imgsPath;
    private List<String> ossPath;
    private int beginNumber;
    private int endNumber;
    private OssUtil ossUtil;

    public UploadThread(OssUtil ossUtil, List<String> imgsPath, List<String> ossPath, int beginNumber, int endNumber, CountDownLatch countDownLatch) {
        this.ossUtil = ossUtil;
        this.imgsPath = imgsPath;
        this.ossPath = ossPath;
        this.beginNumber = beginNumber;
        this.endNumber = endNumber;
        this.countDownLatch = countDownLatch;
    }

    @Override
    public void run() {
        logger.info(this.getName() + "\u5b50\u7ebf\u7a0b\u4e0a\u4f20\u5f00\u59cb");
        try {
            for (int i = this.beginNumber; i < this.endNumber; ++i) {
                String path = this.ossUtil.upload(new File(this.imgsPath.get(i)), this.ossPath.get(i));
                this.ossPath.set(i, path);
                logger.info("\u6b63\u5728\u4e0a\u4f20" + i + "\u5f20\u56fe\u7247");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.countDownLatch.countDown();
        }
        logger.info(this.getName() + "\u5b50\u7ebf\u7a0b\u4e0a\u4f20\u7ed3\u675f");
    }
}

