/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static Logger logger = LoggerFactory.getLogger(ZipUtils.class);
    private static final String PATCH = "/";
    private static final String BASE_DIR = "";
    private static final int BUFFER = 2048;
    public static final String CHAR_SET = "GBK";

    public static void compress(String fileOutName, List<File> files) throws Exception {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileOutName);
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)fileOutputStream);
            zipOutputStream.setEncoding(CHAR_SET);
            if (files != null && files.size() > 0) {
                int size = files.size();
                for (int i = 0; i < size; ++i) {
                    ZipUtils.compress(files.get(i), zipOutputStream, BASE_DIR);
                }
            }
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public static String compressToBase64(List<File> files) throws Exception {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)bos);
            zipOutputStream.setEncoding(CHAR_SET);
            if (files != null && files.size() > 0) {
                int size = files.size();
                for (int i = 0; i < size; ++i) {
                    ZipUtils.compress(files.get(i), zipOutputStream, BASE_DIR);
                }
            }
            zipOutputStream.flush();
            zipOutputStream.close();
            byte[] data = bos.toByteArray();
            return new String(Base64.encodeBase64((byte[])data));
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public static void compress(File srcFile, ZipOutputStream zipOutputStream, String basePath) throws Exception {
        if (srcFile.isDirectory()) {
            ZipUtils.compressDir(srcFile, zipOutputStream, basePath);
        } else {
            ZipUtils.compressFile(srcFile, zipOutputStream, basePath);
        }
    }

    private static void compressDir(File dir, ZipOutputStream zipOutputStream, String basePath) throws Exception {
        try {
            File[] files = dir.listFiles();
            if (files.length < 1) {
                ZipEntry zipEntry = new ZipEntry(basePath + dir.getName() + PATCH);
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.closeEntry();
            }
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                ZipUtils.compress(files[i], zipOutputStream, basePath + dir.getName() + PATCH);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    private static void compressFile(File file, ZipOutputStream zipOutputStream, String dir) throws Exception {
        try {
            ZipEntry zipEntry = new ZipEntry(dir + file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            int count = 0;
            byte[] data = new byte[2048];
            while ((count = bis.read(data, 0, 2048)) != -1) {
                zipOutputStream.write(data, 0, count);
            }
            bis.close();
            zipOutputStream.closeEntry();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public static String encodeToBASE64(File srcFile) throws Exception {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(srcFile));
            int count = 0;
            byte[] data = new byte[2048];
            while ((count = bis.read(data, 0, 2048)) != -1) {
                bos.write(data, 0, count);
            }
            bis.close();
            byte[] base64Data = Base64.encodeBase64((byte[])bos.toByteArray());
            if (null == base64Data) {
                bos.close();
                return null;
            }
            bos.close();
            return new String(base64Data, CHAR_SET);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public static void decodeToBase64(File destFile, String encodeStr) throws Exception {
        try {
            byte[] decodeBytes = Base64.decodeBase64((byte[])encodeStr.getBytes());
            ByteArrayInputStream bis = new ByteArrayInputStream(decodeBytes);
            FileOutputStream fileOutputStream = new FileOutputStream(destFile);
            int count = 0;
            byte[] data = new byte[2048];
            while ((count = bis.read(data, 0, 2048)) != -1) {
                fileOutputStream.write(data, 0, count);
            }
            fileOutputStream.close();
            bis.close();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public static void decompress(String srcFileName, String destFileName) throws Exception {
        try {
            ZipFile zipFile = new ZipFile(srcFileName);
            Enumeration entries = zipFile.getEntries();
            File destFile = new File(destFileName);
            InputStream inputStream = null;
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)entries.nextElement();
                String dir = destFile.getPath() + File.separator + zipEntry.getName();
                File dirFile = new File(dir);
                if (zipEntry.isDirectory()) {
                    dirFile.mkdirs();
                    continue;
                }
                ZipUtils.fileProber(dirFile);
                inputStream = zipFile.getInputStream(zipEntry);
                ZipUtils.decompressFile(dirFile, inputStream);
            }
            zipFile.close();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    private static void decompressFile(File destFile, InputStream inputStream) throws Exception {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
            int count = 0;
            byte[] data = new byte[2048];
            while ((count = inputStream.read(data, 0, 2048)) != -1) {
                bos.write(data, 0, count);
            }
            bos.close();
            inputStream.close();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    private static void fileProber(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            ZipUtils.fileProber(parentFile);
            parentFile.mkdir();
        }
    }

    public static void main(String[] args) {
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new FileOutputStream(new File("C:\\Users\\admin\\Desktop\\doc-convert\\tmp\\doc\\a.zip")));
            zipOutputStream.setEncoding(CHAR_SET);
            ArrayList<File> files = new ArrayList<File>();
            files.add(new File("C:\\Users\\admin\\Desktop\\doc-convert\\tmp\\doc\\Template1.png"));
            files.add(new File("C:\\Users\\admin\\Desktop\\doc-convert\\tmp\\doc\\15843495628093156.pdf"));
            files.add(new File("C:\\Users\\admin\\Desktop\\doc-convert\\tmp\\doc\\\u526f\u672c\u9633\u5149\u57ce\u670d\u52a1\u5668\u6e05\u53550308.xlsx"));
            if (files.size() > 0) {
                int size = files.size();
                for (int i = 0; i < size; ++i) {
                    ZipUtils.compress((File)files.get(i), zipOutputStream, BASE_DIR);
                }
            }
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

