/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tower.storage.client;

import com.alibaba.fastjson.JSON;
import com.xforceplus.tower.file.client.api.FileStorageApi;
import com.xforceplus.tower.file.client.model.Response;
import com.xforceplus.tower.file.client.model.StorageOrig;
import javax.validation.constraints.NotNull;
import kong.unirest.GenericType;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileStorageApiClient
implements FileStorageApi {
    @Value(value="${file.domain:http://paas-t.xforceplus.com/api}")
    private String fileDomain;
    private static final String READ_SIGNATURE_PATH = "/{tenantId}/storage/v1/file/records/{id}/signature/r";
    private static final String WRITE_SIGNATURE_PATH = "/{tenantId}/storage/v1/file/signature/w";
    private static final String THUMBNAIL_PATH = "/{tenantId}/storage/v1/file/records/{id}/thumbnail";
    private static final String CHECK_FILE_EXSIT_PATH = "/{tenantId}/storage/v1/file/exist";
    private final Logger logger = LoggerFactory.getLogger(FileStorageApiClient.class);

    public Response<String> getReadSignature(Long tenantId, Long id, @NotNull Long expireTime, @NotNull StorageOrig storageOrig) {
        HttpResponse response;
        try {
            response = ((GetRequest)((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)(this.fileDomain + READ_SIGNATURE_PATH)).routeParam("tenantId", tenantId + "")).routeParam("id", id + "")).queryString("expireTime", (Object)expireTime)).queryString("storageOrig", (Object)storageOrig.name())).asObject((GenericType)new GenericType<Response<String>>(){});
            this.logger.info("Response\u8c03\u7528\u6587\u4ef6\u670d\u52a1, url = {}, tenantId = {}, id = {}, expireTime = {}, storageOrig = {},response.getBody={}", new Object[]{this.fileDomain + READ_SIGNATURE_PATH, tenantId, id, expireTime, storageOrig.name(), response.getBody()});
            if (!response.isSuccess()) {
                throw new RuntimeException("\u8c03\u7528\u6587\u4ef6\u670d\u52a1\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (Response)response.getBody();
    }

    public Response getWriteSignature(Long tenantId, @NotNull String filePath, @NotNull Long expireTime, @NotNull StorageOrig storageOrig) {
        HttpResponse response;
        try {
            response = ((GetRequest)((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)(this.fileDomain + WRITE_SIGNATURE_PATH)).routeParam("tenantId", tenantId + "")).queryString("filePath", (Object)filePath)).queryString("expireTime", (Object)expireTime)).queryString("storageOrig", (Object)storageOrig.name())).asObject(Response.class);
            this.logger.debug("\u8c03\u7528\u6587\u4ef6\u670d\u52a1, url = {}, tenantId = {}, filePath = {}, expireTime = {}, storageOrig = {}", new Object[]{this.fileDomain + WRITE_SIGNATURE_PATH, tenantId, filePath, expireTime, storageOrig.name()});
            if (!response.isSuccess()) {
                throw new RuntimeException("\u8c03\u7528\u6587\u4ef6\u670d\u52a1\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (Response)response.getBody();
    }

    public Response<String> getThumbnail(Long tenantId, Long id, @NotNull Integer height, @NotNull Integer width) {
        HttpResponse response;
        try {
            response = ((GetRequest)((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)(this.fileDomain + THUMBNAIL_PATH)).routeParam("tenantId", tenantId + "")).queryString("id", (Object)id)).queryString("height", (Object)height)).queryString("width", (Object)width)).asObject((GenericType)new GenericType<Response<String>>(){});
            this.logger.info("\u8c03\u7528\u6587\u4ef6\u670d\u52a1, url = {}, tenantId = {}, id = {}, height = {}, width = {}, response = {}", new Object[]{this.fileDomain + THUMBNAIL_PATH, tenantId, id, height, width, JSON.toJSONString((Object)response)});
            if (!response.isSuccess()) {
                throw new RuntimeException("\u8c03\u7528\u6587\u4ef6\u670d\u52a1\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (Response)response.getBody();
    }

    public boolean checkFileExsit(Long tenantId, @NotNull String filePath, @NotNull StorageOrig storageOrig) {
        HttpResponse response;
        try {
            response = ((GetRequest)((GetRequest)((GetRequest)Unirest.get((String)(this.fileDomain + CHECK_FILE_EXSIT_PATH)).routeParam("tenantId", tenantId + "")).queryString("filePath", (Object)filePath)).queryString("storageOrig", (Object)storageOrig.name())).asObject(Boolean.class);
            this.logger.info("\u8c03\u7528\u6587\u4ef6\u670d\u52a1, url = {}, tenantId = {}, filePath = {}, storageOrig = {}, response = {}", new Object[]{this.fileDomain + CHECK_FILE_EXSIT_PATH, tenantId, filePath, storageOrig.name(), JSON.toJSONString((Object)response)});
            if (!response.isSuccess()) {
                throw new RuntimeException("\u8c03\u7528\u6587\u4ef6\u670d\u52a1\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (Boolean)response.getBody();
    }
}

