package com.xplat.ultraman.api.management.commons.id.node;

/**
 * 依赖 StateFulSet 生成的 pod hostname 最后的序号.
 *
 * @author dongbin
 * @version 0.1 2020/4/1 18:00
 * @since 1.8
 */
public class KubernetesStateFulSetNodeIdGenerator implements NodeIdGenerator {

    @Override
    public Integer nextId() {
        String hostName = System.getenv("HOSTNAME");

        if (hostName == null) {
            throw new IllegalStateException("The HOSTNAME environment variable could not be found.");
        }

        String[] temp = hostName.split("-");

        return Integer.parseInt(temp[temp.length - 1]);
    }
}
