package com.xplat.ultraman.api.management.restclient.adapt.provider;

import com.xplat.ultraman.api.management.pojo.auth.AuthTemplateType;
import com.xplat.ultraman.api.management.restclient.adapt.template.AbstractAuthTemplate;
import com.xplat.ultraman.api.management.restclient.dto.AgentClient;
import com.xplat.ultraman.api.management.restclient.exception.RestCallException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * Created by justin.xu on 10/2021.
 *
 * @since 1.8
 */
public class RestAuthTemplateProvider implements AuthTemplateProvider, ApplicationContextAware, InitializingBean {

    private static final Map<AuthTemplateType, AbstractAuthTemplate> SUPPORT_TEMPLATES = new HashMap<>();
    private ApplicationContext applicationContext;

    @Override
    public void evaluate(AgentClient<?> agentClient) {
        AbstractAuthTemplate authTemplate = SUPPORT_TEMPLATES.get(agentClient.getTemplate().getType());
        if (null == authTemplate) {
            throw new RestCallException(String.format("add auth failed, template not provided, template code : ", agentClient.getTemplate()));
        }

        authTemplate.evaluate(agentClient);
    }


    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }


    @Override
    public void afterPropertiesSet() throws Exception {
        applicationContext.getBeansOfType(AbstractAuthTemplate.class).entrySet().stream().forEach(entry->{
            SUPPORT_TEMPLATES.put(entry.getValue().getType(),entry.getValue());
        });
    }
}
