package com.xplat.ultraman.api.management.restclient.adapt.template;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.xplat.ultraman.api.management.pojo.auth.ApiKey;
import com.xplat.ultraman.api.management.pojo.auth.ApiKeyEntity;
import com.xplat.ultraman.api.management.pojo.auth.ApisAuthTemplateEnv;
import com.xplat.ultraman.api.management.pojo.auth.AuthTemplateType;
import com.xplat.ultraman.api.management.pojo.auth.AuthTemplateVo;
import com.xplat.ultraman.api.management.pojo.auth.EnvVariable;
import com.xplat.ultraman.api.management.pojo.enums.ApiKeyType;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import com.xplat.ultraman.api.management.restclient.dto.AgentClient;
import com.xplat.ultraman.api.management.restclient.dto.AuthTemplate;
import com.xplat.ultraman.api.management.restclient.exception.AuthTemplateInvalidException;
import com.xplat.ultraman.api.management.restclient.rest.ParameterTypeReference;
import com.xplat.ultraman.api.management.restclient.rest.Resty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

/**
 * .
 *
 * @author leo
 * @version 0.1 10/19/21 5:36 PM
 * @since 1.8
 */
public class ApiKeyAuthTemplate extends AbstractAuthTemplate {

    @Value("${ultraman.api.server:http://localhost:8080}")
    private String apiServerHost;

    @Autowired
    private ValueRenderManager valueRenderManager;

    private static final Gson gson = new Gson();

    private static final String apiPath = "/global/auth-template";


    @Override
    public AuthTemplateType getType() {
        return AuthTemplateType.API_KEY_AUTH;
    }

    @Override
    public void evaluate(AgentClient<?> agentClient) {
        Optional<AuthTemplateVo> templateVo = getAgentTemplate(agentClient.getTemplate());
        if (!templateVo.isPresent() || templateVo.get().getTemplate() == null || templateVo.get().getEnvs().isEmpty()) {
            throw new AuthTemplateInvalidException("Template or env is Empty!");
        }
        AuthTemplateType authTemplateType = AuthTemplateType.from(templateVo.get().getTemplate().getAuthTemplateType());
        if (!authTemplateType.equals(AuthTemplateType.API_KEY_AUTH)) {
            throw new AuthTemplateInvalidException("Does not support this template!");
        }
        ApisAuthTemplateEnv env = templateVo.get().getEnvs().stream()
            .filter(item -> item.getEnvCode().equals(agentClient.getTemplate().getEnv())).collect(Collectors.toList())
            .get(0);
        String envStr = env.getEnvVariable();
        List<EnvVariable> variables = gson.fromJson(envStr, new TypeToken<List<EnvVariable>>() {
        }.getType());
        List<EnvVariable> variableFromAgent = agentClient.getHeaderVariables().entrySet().stream()
            .map(entry -> EnvVariable.builder().variableKey(entry.getKey()).variableValue(entry.getValue()).build()).collect(Collectors.toList());
        variables.addAll(variableFromAgent);
        String content = templateVo.get().getTemplate().getAuthTemplateContent();
        ApiKeyEntity entity = gson.fromJson(content, ApiKeyEntity.class);
        renderTemplate(entity, variables);
        agentClient.setHost(entity.getApiHost());
        agentClient.getHeaders()
            .putAll(entity.getHeaders().stream().collect(Collectors.toMap(ApiKey::getKey, v -> v.getValue())));
        agentClient.getParameters()
            .putAll(entity.getParams().stream().collect(Collectors.toMap(ApiKey::getKey, v -> v.getValue())));
    }

    private void renderTemplate(ApiKeyEntity entity, List<EnvVariable> variables) {
        entity.setApiHost(valueRenderManager.render(entity.getApiHost(), variables, ApiKeyType.NORMAL));
        entity.setAuthUrl(valueRenderManager.render(entity.getAuthUrl(), variables, ApiKeyType.NORMAL));
        entity.setClient(valueRenderManager.render(entity.getClient(), variables, ApiKeyType.NORMAL));
        entity.setSecret(valueRenderManager.render(entity.getSecret(), variables, ApiKeyType.NORMAL));
        entity.getHeaders().stream()
            .forEach(item -> item.setValue(valueRenderManager.render(item.getValue(), variables, item.getType())));
        entity.getParams().stream()
            .forEach(item -> item.setValue(valueRenderManager.render(item.getValue(), variables, item.getType())));

    }

    private Optional<AuthTemplateVo> getAgentTemplate(AuthTemplate template) {
        Map<String, String> params = new HashMap<>();
        params.put("templateCode", template.getCode());
        params.put("env", template.getEnv());
        Resty resty = null;
        try {
            resty = Resty.create(String.format("%s%s", apiServerHost, apiPath), params);
            AuthTemplateVo templateVo = resty.get(new ParameterTypeReference<AuthTemplateVo>() {
            });
            return Optional.ofNullable(templateVo);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

}
