package com.xplat.ultraman.api.management.restclient.adapt.template;

import com.xplat.ultraman.api.management.pojo.auth.EnvVariable;
import com.xplat.ultraman.api.management.pojo.enums.ApiKeyType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * .
 *
 * @author leo
 * @version 0.1 10/20/21 8:40 PM
 * @since 1.8
 */
public class ValueRenderManager implements InitializingBean, ApplicationContextAware {

    private Map<String, ValueRender> registedParser = new ConcurrentHashMap<>();

    private ApplicationContext applicationContext;

    public String render(String pattern, List<EnvVariable> envs, ApiKeyType type){
        String newValue = pattern;
        for (ValueRender render : registedParser.values()) {
            if (render.needHandle(newValue,type)) {
                newValue = render.render(newValue,envs);
            }
        }
        return newValue;
    }

    @Override
    public void afterPropertiesSet() {
        applicationContext.getBeansOfType(ValueRender.class).entrySet().stream().forEach(entry -> {
            registedParser.put(entry.getKey(), entry.getValue());
        });
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
