package com.xplat.ultraman.api.management.restclient.adapt.template.render;

import com.xplat.ultraman.api.management.pojo.auth.EnvVariable;
import com.xplat.ultraman.api.management.pojo.enums.ApiKeyType;
import com.xplat.ultraman.api.management.restclient.adapt.template.ValueRender;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author leo
 * @version 0.1 10/20/21 8:03 PM
 * @since 1.8
 */
public class ValueRenderEnvImpl implements ValueRender {

    private static final String REGEX_PATTEN = "(\\$\\{[^#${}]*\\})";

    @Override
    public String render(String origin, List<EnvVariable> envs) {
        Map<String,EnvVariable> envVariableMap = envs.stream().collect(Collectors.toMap(EnvVariable::getVariableKey,v->v));
        Pattern pattern = Pattern.compile(REGEX_PATTEN);
        Matcher matcher =  pattern.matcher(origin);
        StringBuffer sb = new StringBuffer();
        while(matcher.find()) {
            String  matchStr = matcher.group();
            matcher.appendReplacement(sb,Matcher.quoteReplacement(envVariableMap.get(matchStr).getVariableValue()));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    @Override
    public boolean needHandle(String origin, ApiKeyType type) {
        Pattern pattern = Pattern.compile(REGEX_PATTEN);
        Matcher matcher = pattern.matcher(origin);
        return matcher.find() && type.equals(ApiKeyType.NORMAL);
    }

}
