package com.xplat.ultraman.api.management.restclient.agent.delegate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xplat.ultraman.api.management.pojo.enums.Method;
import com.xplat.ultraman.api.management.restclient.adapt.provider.AuthTemplateProvider;
import com.xplat.ultraman.api.management.restclient.dto.AgentClient;
import com.xplat.ultraman.api.management.restclient.rest.Resty;
import com.xplat.ultraman.api.management.restclient.utils.UrlUtils;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by justin.xu on 10/2021.
 *
 * @since 1.8
 */
public abstract class AbstractCall implements RestCall {

    private static final String DATE_PATTERN = "yyyy-MM-dd'T'hh:mm:ss";
    private Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    private Logger logger = LoggerFactory.getLogger(AbstractCall.class);


    protected Resty createRestClient(AuthTemplateProvider authTemplateProvider, AgentClient<?> agentClient) throws IOException {
        replacePathVariables(agentClient);

        //  增加模版鉴权信息
        authTemplateProvider.evaluate(agentClient);

        Resty resty = Resty.create(getFinalUrl(agentClient),agentClient.getParameters(),DATE_PATTERN);

        if (null != agentClient.getHeaders()) {
            resty.setHeaders(agentClient.getHeaders());
        }

        if (null != agentClient.getParameters() && !agentClient.getParameters().isEmpty()) {
            resty.addAllParameters(agentClient.getParameters());
        }

        return resty;
    }

    protected String getFinalUrl(AgentClient<?> agentClient) {
        String finalUrl = agentClient.getHost() + agentClient.getUrl();
        if (!agentClient.getHost().startsWith("http")) {
            finalUrl = "http" + finalUrl;
        }
        return finalUrl;
    }

    protected void setBodyWithType(Resty resty, String bodyType, Object body) {
        resty.addMediaType(bodyType);
        resty.requestBody(body);
    }


    protected void replacePathVariables(AgentClient<?> agentClient) {
        Map<String, String> pathVariables = agentClient.getPathVariables();
        if (null != pathVariables && StringUtils.isNotBlank(agentClient.getUrl())) {
            pathVariables.forEach(
                (k, v) -> {
                    agentClient.resetUrl(UrlUtils.replace(agentClient.getUrl(), k, v));
                }
            );
        }
    }

    protected void printRequest(Resty resty, Object bodyObject, Method method) {
        try {
            logger.info("send request {}, url : {}, headers : {}, requestBody : {}",
                method.name(), resty.getUrl(),
                null != resty.getHeaders() ? GSON.toJson(resty.getHeaders()) : "null",
                null != bodyObject ? GSON.toJson(bodyObject) : "null");
        } catch (Exception e) {
            // ignore
        }
    }
}
