package com.xplat.ultraman.api.management.restclient.agent.executor;

import static com.xplat.ultraman.api.management.pojo.enums.Method.DELETE;
import static com.xplat.ultraman.api.management.pojo.enums.Method.GET;
import static com.xplat.ultraman.api.management.pojo.enums.Method.POST;
import static com.xplat.ultraman.api.management.pojo.enums.Method.PUT;

import com.xplat.ultraman.api.management.pojo.enums.Method;
import com.xplat.ultraman.api.management.restclient.adapt.provider.AuthTemplateProvider;
import com.xplat.ultraman.api.management.restclient.agent.delegate.Delete;
import com.xplat.ultraman.api.management.restclient.agent.delegate.Get;
import com.xplat.ultraman.api.management.restclient.agent.delegate.Post;
import com.xplat.ultraman.api.management.restclient.agent.delegate.Put;
import com.xplat.ultraman.api.management.restclient.agent.delegate.RestCall;
import com.xplat.ultraman.api.management.restclient.dto.AgentClient;
import com.xplat.ultraman.api.management.restclient.exception.RestCallException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;

/**
 * Created by justin.xu on 10/2021.
 *
 * @since 1.8
 */
public class RestAgentExecutor implements AgentExecutor {

    @Resource(name = "restAuthTemplateProvider")
    private AuthTemplateProvider authTemplateProvider;

    private static final Map<Method, RestCall> AGENT_CALLERS = new HashMap<>();

    public RestAgentExecutor() {
        initAgentMaps();
    }

    private static void initAgentMaps() {
        AGENT_CALLERS.put(GET, new Get());
        AGENT_CALLERS.put(POST, new Post());
        AGENT_CALLERS.put(PUT, new Put());
        AGENT_CALLERS.put(DELETE, new Delete());
    }

    @Override
    public Object execute(AgentClient<?> agentClient) {
        if (null == agentClient) {
            throw new RestCallException("agentClient不能为空.");
        }

        RestCall call = AGENT_CALLERS.get(agentClient.getHttpMethod());
        if (null == call) {
            throw new RestCallException("不支持的请求方式 : " + agentClient.getHttpMethod());
        }

        try {
            return call.execute(authTemplateProvider, agentClient);
        } catch (IOException ex) {
            throw new RestCallException(ex.getMessage());
        }
    }
}
