package com.xplat.ultraman.api.management.restclient.config;

import com.xplat.ultraman.api.management.restclient.adapt.provider.AuthTemplateProvider;
import com.xplat.ultraman.api.management.restclient.adapt.provider.RestAuthTemplateProvider;
import com.xplat.ultraman.api.management.restclient.adapt.template.ApiKeyAuthTemplate;
import com.xplat.ultraman.api.management.restclient.adapt.template.ValueRenderManager;
import com.xplat.ultraman.api.management.restclient.adapt.template.render.ValueRenderEnvImpl;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import com.xplat.ultraman.api.management.restclient.agent.executor.RestAgentExecutor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by justin.xu on 10/2021.
 *
 * @since 1.8
 */
@Configuration
public class RestClientConfiguration {

    @Bean("restAuthTemplateProvider")
    public AuthTemplateProvider authTemplateProvider() {
        return new RestAuthTemplateProvider();
    }

    @Bean("restAgentExecutor")
    public AgentExecutor agentExecutor() {
        return new RestAgentExecutor();
    }

    @Bean
    public ApiKeyAuthTemplate apiKeyAuthTemplate() {
        ApiKeyAuthTemplate template = new ApiKeyAuthTemplate();
        return template;
    }

    @Bean
    public ValueRenderManager valueRenderManager() {
        ValueRenderManager manager = new ValueRenderManager();
        return manager;
    }

    @Bean("envValueRender")
    public ValueRenderEnvImpl valueRenderEnv() {
        ValueRenderEnvImpl valueRenderEnv = new ValueRenderEnvImpl();
        return valueRenderEnv;
    }
}
