package com.xplat.ultraman.api.management.restclient.dto;

import com.xplat.ultraman.api.management.pojo.enums.Method;
import com.xplat.ultraman.api.management.restclient.rest.ParameterTypeReference;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by justin.xu on 10/2021.
 *
 * @since 1.8
 */
public class AgentClient<R> implements Serializable {
    private String host;
    private AuthTemplate template;
    private String url;
    private Method httpMethod;
    private Map<String, String> headers;
    private Map<String, String> parameters;
    private Map<String, String> pathVariables;
    private Map<String,String> headerVariables;
    private Object body;
    private ParameterTypeReference<R> parameterTypeReference;

    public AuthTemplate getTemplate() {
        return template;
    }


    public String getUrl() {
        return url;
    }


    public void resetUrl(String url) {
        this.url = url;
    }

    public Method getHttpMethod() {
        return httpMethod;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public Map<String, String> getParameters() {
        return parameters;
    }

    public Map<String, String> getPathVariables() {
        return pathVariables;
    }

    public Map<String, String> getHeaderVariables() {
        return headerVariables;
    }

    public void setHeaderVariables(Map<String, String> headerVariables) {
        this.headerVariables = headerVariables;
    }

    public Object getBody() {
        return body;
    }

    public ParameterTypeReference<R> getParameterTypeReference() {
        return parameterTypeReference;
    }


    private AgentClient() {
        this.headers = new HashMap<>();
        this.parameters = new HashMap<>();
        this.pathVariables = new HashMap<>();
    }

    /**
     * desc :
     * name : AgentClientBuilder
     *
     * @param <R>
     * @author : xujia
     * date : 2020/4/22
     * @since : 1.8
     */
    public static class AgentClientBuilder<R> {
        private AuthTemplate template;
        private String url;
        private Method httpMethod;
        private Map<String, String> headers = new HashMap<>();
        private Map<String, String> parameters = new HashMap<>();
        private Map<String, String> pathVariables = new HashMap<>();
        private Object body;
        private ParameterTypeReference<R> parameterTypeReference;
        private Map<String,String> headerVariables = new HashMap<>();

        public AgentClientBuilder(AuthTemplate template, String url) {
            this.template = template;
            this.url = url;
        }

        public AgentClientBuilder<R> method(Method httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public AgentClientBuilder<R> headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public AgentClientBuilder<R> header(String key, String value) {
            if (null == this.headers) {
                this.headers = new HashMap<>();
            }
            this.headers.put(key, value);
            return this;
        }

        public AgentClientBuilder<R> pathVariables(Map<String, String> pathVariables) {
            this.pathVariables = pathVariables;
            return this;
        }

        public AgentClientBuilder<R> pathVariables(String key, String value) {
            if (null == this.pathVariables) {
                this.pathVariables = new HashMap<>();
            }
            this.pathVariables.put(key, value);
            return this;
        }

        public AgentClientBuilder<R> parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public AgentClientBuilder<R> parameters(String key, String value) {
            if (null == this.parameters) {
                this.parameters = new HashMap<>();
            }
            this.parameters.put(key, value);
            return this;
        }

        public AgentClientBuilder<R> body(Object body) {
            this.body = body;
            return this;
        }

        public AgentClientBuilder<R> parameterTypeReference(ParameterTypeReference<R> parameterTypeReference) {
            this.parameterTypeReference = parameterTypeReference;
            return this;
        }


        public AgentClientBuilder<R> headerVariables(Map<String, String> headerVariables) {
            this.headerVariables = headerVariables;
            return this;
        }

        public AgentClientBuilder<R> headerVariables(String ...params) {
            if(params.length < 2) {
                throw  new IllegalArgumentException("key value must be great equal than 2");
            }
            Map<String,String> tmp = new HashMap<>();
            for(int i = 0;i<params.length;i++) {
                tmp.put(params[i],params[i+1]);
                i++;
            }
            this.headerVariables = tmp;
            return this;
        }

        public AgentClient<R> builder() {
            AgentClient<R> agentClient = new AgentClient<>();

            agentClient.template = this.template;
            agentClient.url = this.url;
            agentClient.httpMethod = this.httpMethod;
            agentClient.headers = this.headers;
            agentClient.parameters = this.parameters;
            agentClient.pathVariables = this.pathVariables;
            agentClient.body = this.body;
            agentClient.parameterTypeReference = this.parameterTypeReference;
            agentClient.headerVariables = this.headerVariables;

            return agentClient;
        }
    }
}
