package com.xplat.ultraman.api.management.restclient.rest;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 * .
 *
 * @author leo
 * @version 0.1 10/21/21 4:53 PM
 * @since 1.8
 */
public class DateDeserializer implements JsonDeserializer<Date> {

    private String datePattern = "yyyy-MM-dd'T'HH:mm:ss";

    public DateDeserializer(String datePattern) {
        this.datePattern = datePattern;
    }

    public DateDeserializer(){};


    @Override
    public Date deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context)
        throws JsonParseException {
        String date = element.getAsString();

        SimpleDateFormat format = new SimpleDateFormat(datePattern);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));

        try {
            return format.parse(date);
        } catch (ParseException exp) {
            System.err.println(exp.getMessage());
            return null;
        }
    }
}
