/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.sql.create;

import com.xforceplus.ultraman.bocp.gen.po.BoField;
import com.xforceplus.ultraman.bocp.gen.po.BoInfo;
import com.xforceplus.ultraman.bocp.gen.sql.create.CreateModel;
import java.util.List;

public class CreateDSL {
    public static String create(CreateModel createModel) {
        StringBuffer sql = new StringBuffer();
        if (createModel == null) {
            return null;
        }
        if (createModel.getBoInfoList() != null) {
            List<BoInfo> boInfos = createModel.getBoInfoList();
            for (BoInfo bo : boInfos) {
                if (createModel.getDropCf() != null && createModel.getDropCf().booleanValue()) {
                    sql.append("drop table if exists " + bo.getName() + ";");
                    sql.append("\n");
                }
                if (createModel.getDeleteCf() != null && createModel.getDeleteCf().booleanValue()) {
                    sql.append("delete table if exists " + bo.getName() + ";");
                    sql.append("\n");
                }
                sql.append("create table " + bo.getName() + "(");
                sql.append("\n");
                List<BoField> fields = bo.getBoFieldList();
                if (fields == null) {
                    sql.append("id bigint not null comment 'id',");
                    sql.append("primary key (id)");
                    sql.append(")");
                    sql.append("\n");
                    sql.append("alter table " + bo.getName() + " " + "comment" + " " + "'" + bo.getRemark() + "'" + ";");
                    break;
                }
                for (BoField field : fields) {
                    boolean last;
                    sql.append(field.getName() + " ");
                    switch (field.getFieldType()) {
                        case "String": {
                            sql.append("varchar(" + (null != field.getLength() ? field.getLength() : 256) + ")" + " ");
                            break;
                        }
                        case "int": {
                            sql.append("bigint ");
                            break;
                        }
                        case "datetime": {
                            sql.append("datetime ");
                            break;
                        }
                        default: {
                            sql.append("varchar(" + (null != field.getLength() ? field.getLength() : 256) + ")" + " ");
                        }
                    }
                    if (field.getNullKey() != null) {
                        sql.append("not null ");
                    }
                    if (field.getFieldKey() != null) {
                        sql.append("primary key ");
                    }
                    if (field.getRemark() != null) {
                        sql.append("comment '" + field.getRemark() + "'");
                    }
                    boolean bl = last = field.getName() == fields.get(fields.size() - 1).getName();
                    if (!last) {
                        sql.append(",");
                    }
                    sql.append("\n");
                }
                sql.append(");");
                sql.append("\n");
                sql.append("alter table " + bo.getName() + " " + "comment" + " " + "'" + bo.getRemark() + "'" + ";");
            }
        }
        return sql.toString();
    }
}

