/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.config;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.xforceplus.ultraman.bocp.gen.config.ApplicationConfig;
import com.xforceplus.ultraman.bocp.gen.config.BoConfig;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.config.DictConfig;
import com.xforceplus.ultraman.bocp.gen.config.DtoConfig;
import com.xforceplus.ultraman.bocp.gen.config.ModuleConfig;
import com.xforceplus.ultraman.bocp.gen.config.PfcpConfig;
import com.xforceplus.ultraman.bocp.gen.config.ProjectConfig;
import com.xforceplus.ultraman.bocp.gen.po.BoGenField;
import com.xforceplus.ultraman.bocp.gen.po.BoGenInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ForSdkConfigBuilder {
    private ProjectConfig projectConfig;
    private ApplicationConfig applicationConfig;
    private PackageConfig packageConfig;
    private ModuleConfig moduleConfig;
    private BoConfig boConfig;
    private DictConfig dictConfig;
    private DtoConfig dtoConfig;
    private PfcpConfig pfcpConfig;
    private BocpTemplateConfig bocpTemplate;
    private String superEntityClass;
    private String superMapperClass;
    private TableInfo baseEntity;
    private String superServiceClass;
    private String superServiceImplClass;
    private String superControllerClass;
    private List<TableInfo> tableInfoList;
    private Map<String, String> packageInfo;
    private Map<String, String> pathInfo;
    private StrategyConfig strategyConfig;
    private GlobalConfig globalConfig;
    private InjectionConfig injectionConfig;
    private boolean commentSupported;

    public ForSdkConfigBuilder(ProjectConfig projectConfig, ApplicationConfig applicationConfig, ModuleConfig moduleConfig, BoConfig boConfig, DictConfig dictConfig, DtoConfig dtoConfig, PfcpConfig pfcpConfig, PackageConfig packageConfig, StrategyConfig strategyConfig, BocpTemplateConfig bocpTemplate, GlobalConfig globalConfig) {
        this.projectConfig = projectConfig;
        this.applicationConfig = applicationConfig;
        this.moduleConfig = moduleConfig;
        this.boConfig = boConfig;
        this.dictConfig = dictConfig;
        this.dtoConfig = dtoConfig;
        this.pfcpConfig = pfcpConfig;
        this.globalConfig = globalConfig;
        this.bocpTemplate = new BocpTemplateConfig();
        this.packageConfig = packageConfig;
        if (null != packageConfig) {
            this.handlerPackage(this.bocpTemplate, this.globalConfig.getOutputDir(), packageConfig);
        }
        this.strategyConfig = strategyConfig;
        if (null != boConfig) {
            this.handlerStrategyByBo(this.strategyConfig, boConfig);
        }
    }

    public Map<String, String> getPackageInfo() {
        return this.packageInfo;
    }

    public Map<String, String> getPathInfo() {
        return this.pathInfo;
    }

    public String getSuperEntityClass() {
        return this.superEntityClass;
    }

    public String getSuperMapperClass() {
        return this.superMapperClass;
    }

    public String getSuperServiceClass() {
        return this.superServiceClass;
    }

    public String getSuperServiceImplClass() {
        return this.superServiceImplClass;
    }

    public String getSuperControllerClass() {
        return this.superControllerClass;
    }

    public List<TableInfo> getTableInfoList() {
        return this.tableInfoList;
    }

    public ForSdkConfigBuilder setTableInfoList(List<TableInfo> tableInfoList) {
        this.tableInfoList = tableInfoList;
        return this;
    }

    public BocpTemplateConfig getBocpTemplate() {
        return this.bocpTemplate == null ? new BocpTemplateConfig() : this.bocpTemplate;
    }

    private void handlerPackage(BocpTemplateConfig bocpTemplate, String outputDir, PackageConfig config) {
        Map configPathInfo;
        String projectPath = this.joinPackage(null, this.projectConfig.getName());
        String applicationPath = this.joinPackage(projectPath, this.applicationConfig.getName());
        String applicationServicePath = this.joinPackage(applicationPath, this.applicationConfig.getName() + "-service");
        String modulePath = this.joinPackage(projectPath, this.moduleConfig.getName());
        String moduleDomainPath = this.joinPackage(modulePath, this.moduleConfig.getName() + "-domain");
        String moduleDomainMainPath = this.joinPackage(moduleDomainPath, "src.main.java");
        String moduleDomainPackegePath = this.joinPackage(moduleDomainMainPath, config.getParent());
        this.packageInfo = new HashMap<String, String>(8);
        if (null != this.boConfig) {
            this.packageInfo.put("ModuleName", config.getModuleName());
            this.packageInfo.put("Entity", this.joinPackage(moduleDomainPackegePath, config.getEntity()));
            this.packageInfo.put("BaseEntity", this.joinPackage(moduleDomainPackegePath, config.getEntity()));
            this.packageInfo.put("EntityMeta", this.joinPackage(moduleDomainPackegePath, "metadata"));
            this.packageInfo.put("EntityPackege", this.joinPackage(config.getParent(), config.getEntity()));
            this.packageInfo.put("DictPackage", this.joinPackage(config.getParent(), "dict"));
            this.packageInfo.put("EntityMetaPackage", this.joinPackage(config.getParent(), "metadata"));
        }
        if (this.dictConfig != null) {
            this.packageInfo.put("Enum", this.joinPackage(moduleDomainPackegePath, "dict"));
            this.packageInfo.put("DictPackage", this.joinPackage(config.getParent(), "dict"));
        }
        if (this.dtoConfig != null) {
            this.packageInfo.put("Dto", this.joinPackage(moduleDomainPackegePath, "dto"));
            this.packageInfo.put("DtoPackage", this.joinPackage(config.getParent(), "dto"));
        }
        if (this.pfcpConfig != null) {
            this.packageInfo.put("PageMeta", this.joinPackage(moduleDomainPackegePath, "metadata"));
            this.packageInfo.put("FormMeta", this.joinPackage(moduleDomainPackegePath, "metadata"));
            this.packageInfo.put("EntityMetaPackage", this.joinPackage(config.getParent(), "metadata"));
        }
        if (null != this.applicationConfig.getName()) {
            this.packageInfo.put("Project", projectPath);
            this.packageInfo.put("Application", applicationPath);
        }
        if (null != this.moduleConfig.getName()) {
            this.packageInfo.put("Module", modulePath);
            this.packageInfo.put("DictPackage", this.joinPackage(config.getParent(), "dict"));
            this.packageInfo.put("EntityMetaPackage", this.joinPackage(config.getParent(), "metadata"));
            this.packageInfo.put("DtoPackage", this.joinPackage(config.getParent(), "dto"));
        }
        if (null != (configPathInfo = config.getPathInfo())) {
            this.pathInfo = configPathInfo;
        } else {
            this.pathInfo = new HashMap<String, String>(6);
            if (null != this.boConfig) {
                this.setPathInfo(this.pathInfo, bocpTemplate.getEntity(this.getGlobalConfig().isKotlin()), outputDir, "entity_path", "Entity");
                this.setPathInfo(this.pathInfo, bocpTemplate.getBaseEntity(this.getGlobalConfig().isKotlin()), outputDir, "base_entity_path", "BaseEntity");
                this.setPathInfo(this.pathInfo, bocpTemplate.getEntityMeta(this.getGlobalConfig().isKotlin()), outputDir, "entity_meta_path", "EntityMeta");
            }
            if (null != this.dictConfig) {
                this.setPathInfo(this.pathInfo, bocpTemplate.getEnum(this.getGlobalConfig().isKotlin()), outputDir, "enum_path", "Enum");
            }
            if (null != this.dtoConfig) {
                this.setPathInfo(this.pathInfo, bocpTemplate.getDto(this.getGlobalConfig().isKotlin()), outputDir, "dto_path", "Dto");
            }
            if (null != this.pfcpConfig) {
                this.setPathInfo(this.pathInfo, bocpTemplate.getPageMeta(this.getGlobalConfig().isKotlin()), outputDir, "page_meta_path", "PageMeta");
                this.setPathInfo(this.pathInfo, bocpTemplate.getFormMeta(this.getGlobalConfig().isKotlin()), outputDir, "form_meta_path", "FormMeta");
            }
        }
    }

    private void setPathInfo(Map<String, String> pathInfo, String bocpTemplate, String outputDir, String path, String module) {
        if (StringUtils.isNotEmpty((CharSequence)bocpTemplate)) {
            pathInfo.put(path, this.joinPath(outputDir, this.packageInfo.get(module)));
        }
    }

    private void handlerStrategyByBo(StrategyConfig config, BoConfig boConfig) {
        this.processTypes(config);
        this.tableInfoList = this.getTablesInfoByBo(config, boConfig);
        if (boConfig.getBaseEntity() != null) {
            this.baseEntity = this.buildTableInfo(config, boConfig.getBaseEntity());
            this.nameConvert(this.baseEntity, config.getNaming(), config.getTablePrefix());
        }
    }

    private void processTypes(StrategyConfig config) {
        this.superServiceClass = StringUtils.isEmpty((CharSequence)config.getSuperServiceClass()) ? "com.baomidou.mybatisplus.extension.service.IService" : config.getSuperServiceClass();
        this.superServiceImplClass = StringUtils.isEmpty((CharSequence)config.getSuperServiceImplClass()) ? "com.baomidou.mybatisplus.extension.service.impl.ServiceImpl" : config.getSuperServiceImplClass();
        this.superMapperClass = StringUtils.isEmpty((CharSequence)config.getSuperMapperClass()) ? "com.baomidou.mybatisplus.core.mapper.BaseMapper" : config.getSuperMapperClass();
        this.superEntityClass = config.getSuperEntityClass();
        this.superControllerClass = config.getSuperControllerClass();
    }

    private List<TableInfo> processTable(List<TableInfo> tableList, NamingStrategy strategy, StrategyConfig config) {
        String[] tablePrefix = config.getTablePrefix();
        for (TableInfo tableInfo : tableList) {
            this.nameConvert(tableInfo, strategy, tablePrefix);
            this.checkImportPackages(tableInfo);
        }
        return tableList;
    }

    private void nameConvert(TableInfo tableInfo, NamingStrategy strategy, String[] tablePrefix) {
        INameConvert nameConvert = this.strategyConfig.getNameConvert();
        String entityName = null != nameConvert ? NamingStrategy.capitalFirst((String)this.processName(nameConvert.entityNameConvert(tableInfo), strategy, tablePrefix)) : NamingStrategy.capitalFirst((String)this.processName(tableInfo.getName(), strategy, tablePrefix));
        if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getEntityName())) {
            tableInfo.setConvert(true);
            tableInfo.setEntityName(String.format(this.globalConfig.getEntityName(), entityName));
        } else {
            tableInfo.setEntityName(this.strategyConfig, entityName);
        }
    }

    private void checkImportPackages(TableInfo tableInfo) {
        if (StringUtils.isNotEmpty((CharSequence)this.strategyConfig.getSuperEntityClass())) {
            tableInfo.getImportPackages().add(this.strategyConfig.getSuperEntityClass());
        } else if (this.globalConfig.isActiveRecord()) {
            tableInfo.getImportPackages().add(Model.class.getCanonicalName());
        }
        if (null != this.globalConfig.getIdType()) {
            tableInfo.getImportPackages().add(IdType.class.getCanonicalName());
            tableInfo.getImportPackages().add(TableId.class.getCanonicalName());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.strategyConfig.getVersionFieldName())) {
            tableInfo.getFields().forEach(f -> {
                if (this.strategyConfig.getVersionFieldName().equals(f.getName())) {
                    tableInfo.getImportPackages().add(Version.class.getCanonicalName());
                }
            });
        }
    }

    private List<TableInfo> getTablesInfoByBo(StrategyConfig config, BoConfig boConfig) {
        boolean isExclude;
        if (boConfig.getBoGenInfoList() == null) {
            return new ArrayList<TableInfo>();
        }
        boolean isInclude = null != config.getInclude() && config.getInclude().length > 0;
        boolean bl = isExclude = null != config.getExclude() && config.getExclude().length > 0;
        if (isInclude && isExclude) {
            throw new RuntimeException("<strategy> \u6807\u7b7e\u4e2d <include> \u4e0e <exclude> \u53ea\u80fd\u914d\u7f6e\u4e00\u9879\uff01");
        }
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        ArrayList includeTableList = new ArrayList();
        ArrayList excludeTableList = new ArrayList();
        HashSet notExistTables = new HashSet();
        for (BoGenInfo bo : boConfig.getBoGenInfoList()) {
            TableInfo tableInfo = this.buildTableInfo(config, bo);
            tableList.add(tableInfo);
        }
        return this.processTable(tableList, config.getNaming(), config);
    }

    private TableInfo buildTableInfo(StrategyConfig config, BoGenInfo bo) {
        TableInfo tableInfo = new TableInfo();
        tableInfo.setName(bo.getCode());
        tableInfo.setComment(bo.getName());
        ArrayList<TableField> fieldList = new ArrayList<TableField>();
        ArrayList<TableField> commonFieldList = new ArrayList<TableField>();
        for (BoGenField boGenField : bo.getBoGenFieldList()) {
            TableField field = new TableField();
            String columnName = boGenField.getName();
            if (boGenField.getFieldKey() != null && "1".equals(boGenField.getFieldKey())) {
                field.setKeyIdentityFlag(true);
            } else {
                field.setKeyFlag(false);
            }
            field.setName(columnName);
            field.setComment(boGenField.getRemark());
            field.setType(boGenField.getFieldType());
            INameConvert nameConvert = this.strategyConfig.getNameConvert();
            if (null != nameConvert) {
                field.setPropertyName(this.strategyConfig, this.processName(nameConvert.propertyNameConvert(field), config.getNaming()));
            } else {
                field.setPropertyName(this.strategyConfig, this.processName(field.getName(), config.getNaming()));
            }
            field.setColumnType(new MySqlTypeConvert().processTypeConvert(this.globalConfig, field));
            if ("entity".equals(bo.getBoType()) && this.strategyConfig.includeSuperEntityColumns(field.getName())) {
                commonFieldList.add(field);
                continue;
            }
            List tableFillList = this.getStrategyConfig().getTableFillList();
            if (null != tableFillList) {
                tableFillList.stream().filter(tf -> tf.getFieldName().equalsIgnoreCase(field.getName())).findFirst().ifPresent(tf -> field.setFill(tf.getFieldFill().name()));
            }
            fieldList.add(field);
        }
        tableInfo.setFields(fieldList);
        tableInfo.setCommonFields(commonFieldList);
        return tableInfo;
    }

    private boolean tableNameMatches(String setTableName, String dbTableName) {
        return setTableName.equalsIgnoreCase(dbTableName) || ForSdkConfigBuilder.matches(setTableName, dbTableName);
    }

    public static boolean matches(String regex, String input) {
        return null != regex && null != input ? Pattern.matches(regex, input) : false;
    }

    private String joinPath(String parentDir, String packageName) {
        if (StringUtils.isEmpty((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((CharSequence)parentDir, (CharSequence)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private String joinPackage(String parent, String subPackage) {
        if (StringUtils.isEmpty((CharSequence)parent)) {
            return subPackage;
        }
        return parent + "." + subPackage;
    }

    private String processName(String name, NamingStrategy strategy) {
        return this.processName(name, strategy, this.strategyConfig.getFieldPrefix());
    }

    private String processName(String name, NamingStrategy strategy, String[] prefix) {
        boolean removePrefix = false;
        if (prefix != null && prefix.length != 0) {
            removePrefix = true;
        }
        String propertyName = removePrefix ? (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.removePrefixAndCamel((String)name, (String[])prefix) : NamingStrategy.removePrefix((String)name, (String[])prefix)) : (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.underlineToCamel((String)name) : name);
        return propertyName;
    }

    public StrategyConfig getStrategyConfig() {
        return this.strategyConfig;
    }

    public ForSdkConfigBuilder setStrategyConfig(StrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
        return this;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public ForSdkConfigBuilder setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public InjectionConfig getInjectionConfig() {
        return this.injectionConfig;
    }

    public ForSdkConfigBuilder setInjectionConfig(InjectionConfig injectionConfig) {
        this.injectionConfig = injectionConfig;
        return this;
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public void setProjectConfig(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public void setApplicationConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public void setModuleConfig(ModuleConfig moduleConfig) {
        this.moduleConfig = moduleConfig;
    }

    public BoConfig getBoConfig() {
        return this.boConfig;
    }

    public void setBoConfig(BoConfig boConfig) {
        this.boConfig = boConfig;
    }

    public TableInfo getBaseEntity() {
        return this.baseEntity;
    }

    public void setBaseEntity(TableInfo baseEntity) {
        this.baseEntity = baseEntity;
    }

    public DictConfig getDictConfig() {
        return this.dictConfig;
    }

    public void setDictConfig(DictConfig dictConfig) {
        this.dictConfig = dictConfig;
    }

    public DtoConfig getDtoConfig() {
        return this.dtoConfig;
    }

    public void setDtoConfig(DtoConfig dtoConfig) {
        this.dtoConfig = dtoConfig;
    }

    public PfcpConfig getPfcpConfig() {
        return this.pfcpConfig;
    }

    public void setPfcpConfig(PfcpConfig pfcpConfig) {
        this.pfcpConfig = pfcpConfig;
    }

    public PackageConfig getPackageConfig() {
        return this.packageConfig;
    }

    public void setPackageConfig(PackageConfig packageConfig) {
        this.packageConfig = packageConfig;
    }
}

