/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.gen.config.ForSdkConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.PfcpConfig;
import com.xforceplus.ultraman.bocp.gen.po.BoGenInfo;
import com.xforceplus.ultraman.bocp.gen.po.BoRelInfo;
import com.xforceplus.ultraman.bocp.gen.po.DictGenInfo;
import com.xforceplus.ultraman.bocp.gen.po.FormGenInfo;
import com.xforceplus.ultraman.bocp.gen.po.PageGenInfo;
import com.xforceplus.ultraman.bocp.gen.util.GenFieldUtils;
import com.xforceplus.ultraman.bocp.gen.util.GenFormatUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForSdkMetaVelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(ForSdkMetaVelocityTemplateEngine.class);
    private final List<String> systemFieldCodes = Arrays.asList("id", "tenant_id", "tenant_code", "create_time", "update_time", "create_user_id", "update_user_id", "create_user_name", "update_user_name", "delete_flag");
    public static final String ENTITY_META_PATH = "/templates/EntityMeta.java";
    public static final String PAGE_META_PATH = "/templates/PageMeta.java";
    public static final String FORM_META_PATH = "/templates/FormMeta.java";
    public static final String CHECK_ULT_ENUM_PATH = "/templates/validator/CheckUltramanEnum.java";
    public static final String CHECK_ULT_ENUMS_PATH = "/templates/validator/CheckUltramanEnums.java";
    public static final String CHECK_ULT_EMAIL_PATH = "/templates/validator/CheckUltramanEmail.java";
    public static final String CHECK_ULT_PHONE_PATH = "/templates/validator/CheckUltramanPhone.java";
    public static final String CHECK_ULT_BOOL_PATH = "/templates/validator/CheckUltramanBool.java";
    public static final String ULT_ENUM_CONSTRAINT_VALIDATOR_PATH = "/templates/validator/UltramanEnumConstraintValidator.java";
    public static final String ULT_ENUMS_CONSTRAINT_VALIDATOR_PATH = "/templates/validator/UltramanEnumsConstraintValidator.java";
    public static final String ULT_EMAIL_CONSTRAINT_VALIDATOR_PATH = "/templates/validator/UltramanEmailConstraintValidator.java";
    public static final String ULT_PHONE_CONSTRAINT_VALIDATOR_PATH = "/templates/validator/UltramanPhoneConstraintValidator.java";
    public static final String ULT_BOOL_CONSTRAINT_VALIDATOR_PATH = "/templates/validator/UltramanBoolConstraintValidator.java";
    public static final String ENTITY_META_VALIDATOR_PATH = "/templates/validator/EntityMetaValidator.java";
    public static final String DOT_VM = ".vm";
    protected VelocityEngine velocityEngine;
    protected ForSdkConfigBuilder forSdkConfigBuilder;

    public ForSdkMetaVelocityTemplateEngine init(ForSdkConfigBuilder forSdkConfigBuilder) {
        this.forSdkConfigBuilder = forSdkConfigBuilder;
        if (null == this.velocityEngine) {
            Properties p = new Properties();
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("resource.loader.file.path", "");
            p.setProperty("UTF-8", ConstVal.UTF8);
            p.setProperty("resource.default_encoding", ConstVal.UTF8);
            p.setProperty("file.resource.loader.unicode", "true");
            this.velocityEngine = new VelocityEngine(p);
        }
        return this;
    }

    public void writer(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        if (StringUtils.isEmpty((CharSequence)templatePath)) {
            return;
        }
        Template template = this.velocityEngine.getTemplate(templatePath, ConstVal.UTF8);
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fos, ConstVal.UTF8);
             BufferedWriter writer = new BufferedWriter(ow);){
            template.merge((Context)new VelocityContext(objectMap), (Writer)writer);
        }
        logger.info("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
        System.out.println("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
    }

    public String templateFilePath(String filePath) {
        if (null == filePath || filePath.contains(DOT_VM)) {
            return filePath;
        }
        return filePath + DOT_VM;
    }

    public ForSdkMetaVelocityTemplateEngine mkdirs(String value) {
        boolean result;
        File dir = new File(value);
        if (!dir.exists() && (result = dir.mkdirs())) {
            logger.debug("\u521b\u5efa\u76ee\u5f55\uff1a [" + value + "]");
        }
        return this;
    }

    public ForSdkMetaVelocityTemplateEngine mkdirs() {
        this.getForSdkConfigBuilder().getPathInfo().forEach((key, value) -> {
            boolean result;
            File dir = new File((String)value);
            if (!dir.exists() && (result = dir.mkdirs())) {
                logger.debug("\u521b\u5efa\u76ee\u5f55\uff1a [" + value + "]");
            }
        });
        return this;
    }

    public void open() {
        String outDir = this.getForSdkConfigBuilder().getGlobalConfig().getOutputDir();
        if (this.getForSdkConfigBuilder().getGlobalConfig().isOpen() && StringUtils.isNotEmpty((CharSequence)outDir)) {
            try {
                String osName = System.getProperty("os.name");
                if (osName != null) {
                    if (osName.contains("Mac")) {
                        Runtime.getRuntime().exec("open " + outDir);
                    } else if (osName.contains("Windows")) {
                        Runtime.getRuntime().exec("cmd /c start " + outDir);
                    } else {
                        logger.debug("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + outDir);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String suffixJavaOrKt() {
        return this.getForSdkConfigBuilder().getGlobalConfig().isKotlin() ? ".kt" : ".java";
    }

    public ForSdkConfigBuilder getForSdkConfigBuilder() {
        return this.forSdkConfigBuilder;
    }

    protected Map<String, Object> initTemplateParams() {
        HashMap<String, Object> objectMap = new HashMap<String, Object>(30);
        ForSdkConfigBuilder config = this.getForSdkConfigBuilder();
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("config", config);
        objectMap.put("application", config.getApplicationConfig());
        objectMap.put("project", config.getProjectConfig());
        objectMap.put("package", config.getPackageInfo());
        objectMap.put("module", config.getModuleConfig());
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("enableCache", globalConfig.isEnableCache());
        objectMap.put("packageentity", config.getPackageConfig().getParent() + ".metadata.entity");
        objectMap.put("packagedto", config.getPackageConfig().getParent() + ".metadata.dto");
        objectMap.put("packagedict", config.getPackageConfig().getParent() + ".metadata.dict");
        objectMap.put("packagemeta", config.getPackageConfig().getParent() + ".metadata.meta");
        objectMap.put("packagevalidator", config.getPackageConfig().getParent() + ".metadata.validator");
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        return objectMap;
    }

    public ForSdkMetaVelocityTemplateEngine batchOutput() {
        this.mkdirs(this.getMetadataPath());
        this.mkdirs(this.joinPath("meta"));
        this.mkdirs(this.joinPath("validator"));
        this.mkdirs(this.joinPath("validator.annotation"));
        try {
            List<TableInfo> tableInfoList = this.getForSdkConfigBuilder().getTableInfoList();
            List boGenInfoList = this.getForSdkConfigBuilder().getBoConfig().getBoGenInfoList();
            List dictGenInfos = this.getForSdkConfigBuilder().getDictConfig().getDictGenInfos();
            Map<String, Object> objectMap = this.getMetaObjectMap(tableInfoList, boGenInfoList, dictGenInfos);
            String entityMetaFile = String.format(this.joinPath("meta") + File.separator + "%s" + this.suffixJavaOrKt(), "EntityMeta");
            this.writer(objectMap, this.templateFilePath(ENTITY_META_PATH), entityMetaFile);
            String checkUltramanEnumFile = String.format(this.joinPath("validator.annotation") + File.separator + "%s" + this.suffixJavaOrKt(), "CheckUltramanEnum");
            this.writer(objectMap, this.templateFilePath(CHECK_ULT_ENUM_PATH), checkUltramanEnumFile);
            String checkUltramanEnumsFile = String.format(this.joinPath("validator.annotation") + File.separator + "%s" + this.suffixJavaOrKt(), "CheckUltramanEnums");
            this.writer(objectMap, this.templateFilePath(CHECK_ULT_ENUMS_PATH), checkUltramanEnumsFile);
            String checkUltramanEmailFile = String.format(this.joinPath("validator.annotation") + File.separator + "%s" + this.suffixJavaOrKt(), "CheckUltramanEmail");
            this.writer(objectMap, this.templateFilePath(CHECK_ULT_EMAIL_PATH), checkUltramanEmailFile);
            String checkUltramanPhoneFile = String.format(this.joinPath("validator.annotation") + File.separator + "%s" + this.suffixJavaOrKt(), "CheckUltramanPhone");
            this.writer(objectMap, this.templateFilePath(CHECK_ULT_PHONE_PATH), checkUltramanPhoneFile);
            String checkUltramanBoolFile = String.format(this.joinPath("validator.annotation") + File.separator + "%s" + this.suffixJavaOrKt(), "CheckUltramanBool");
            this.writer(objectMap, this.templateFilePath(CHECK_ULT_BOOL_PATH), checkUltramanBoolFile);
            String ultEnumConstrainValidatorFile = String.format(this.joinPath("validator") + File.separator + "%s" + this.suffixJavaOrKt(), "UltramanEnumConstraintValidator");
            this.writer(objectMap, this.templateFilePath(ULT_ENUM_CONSTRAINT_VALIDATOR_PATH), ultEnumConstrainValidatorFile);
            String ultEnumsConstrainValidatorFile = String.format(this.joinPath("validator") + File.separator + "%s" + this.suffixJavaOrKt(), "UltramanEnumsConstraintValidator");
            this.writer(objectMap, this.templateFilePath(ULT_ENUMS_CONSTRAINT_VALIDATOR_PATH), ultEnumsConstrainValidatorFile);
            String ultEmailConstrainValidatorFile = String.format(this.joinPath("validator") + File.separator + "%s" + this.suffixJavaOrKt(), "UltramanEmailConstraintValidator");
            this.writer(objectMap, this.templateFilePath(ULT_EMAIL_CONSTRAINT_VALIDATOR_PATH), ultEmailConstrainValidatorFile);
            String ultPhoneConstrainValidatorFile = String.format(this.joinPath("validator") + File.separator + "%s" + this.suffixJavaOrKt(), "UltramanPhoneConstraintValidator");
            this.writer(objectMap, this.templateFilePath(ULT_PHONE_CONSTRAINT_VALIDATOR_PATH), ultPhoneConstrainValidatorFile);
            String ultBoolConstrainValidatorFile = String.format(this.joinPath("validator") + File.separator + "%s" + this.suffixJavaOrKt(), "UltramanBoolConstraintValidator");
            this.writer(objectMap, this.templateFilePath(ULT_BOOL_CONSTRAINT_VALIDATOR_PATH), ultBoolConstrainValidatorFile);
            PfcpConfig pfcpConfig = this.getForSdkConfigBuilder().getPfcpConfig();
            objectMap = this.getPfcpMetaObjectMap(pfcpConfig.getPageGenInfos(), pfcpConfig.getFormGenInfos());
            String pageMetaFile = String.format(this.joinPath("meta") + File.separator + "%s" + this.suffixJavaOrKt(), "PageMeta");
            this.writer(objectMap, this.templateFilePath(PAGE_META_PATH), pageMetaFile);
            String formMetaFile = String.format(this.joinPath("meta") + File.separator + "%s" + this.suffixJavaOrKt(), "FormMeta");
            this.writer(objectMap, this.templateFilePath(FORM_META_PATH), formMetaFile);
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
        }
        return this;
    }

    public Map<String, Object> getObjectMap() {
        Map objectMap = this.initTemplateParams();
        ForSdkConfigBuilder config = this.getForSdkConfigBuilder();
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    public Map<String, Object> getMetaObjectMap(List<TableInfo> tableInfos, List<BoGenInfo> boGenInfos, List<DictGenInfo> dictGenInfos) {
        List<BoGenInfo> mainBoGenInfos = boGenInfos.stream().filter(boGenInfo -> !boGenInfo.isTenantBo()).collect(Collectors.toList());
        List<BoGenInfo> tBoGenInfos = boGenInfos.stream().filter(boGenInfo -> boGenInfo.isTenantBo()).collect(Collectors.toList());
        List mainTableInfos = tableInfos.stream().filter(tableInfo -> StringUtils.isEmpty((CharSequence)tableInfo.getComment()) || !tableInfo.getComment().contains("-tenant-")).collect(Collectors.toList());
        List tTableInfos = tableInfos.stream().filter(tableInfo -> !StringUtils.isEmpty((CharSequence)tableInfo.getComment()) && tableInfo.getComment().contains("-tenant-")).collect(Collectors.toList());
        Map objectMap = this.initTemplateParams();
        ForSdkConfigBuilder config = this.getForSdkConfigBuilder();
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put((String)"author", (Object)globalConfig.getAuthor());
        objectMap.put((String)"date", (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        objectMap.put((String)"formatUtils", GenFormatUtils.class);
        objectMap.put((String)"fieldUtils", GenFieldUtils.class);
        if (CollectionUtils.isNotEmpty(mainTableInfos) && CollectionUtils.isNotEmpty(boGenInfos)) {
            objectMap.put((String)"tables", mainTableInfos);
            objectMap.put("bos", mainBoGenInfos);
            objectMap.put("tableIdMap", mainBoGenInfos.stream().collect(Collectors.toMap(BoGenInfo::getCode, BoGenInfo::getId)));
            Map<String, String> boParentMap = mainBoGenInfos.stream().filter(boGenInfo -> !StringUtils.isEmpty((CharSequence)boGenInfo.getParentEntity())).collect(Collectors.toMap(BoGenInfo::getCode, boGenInfo -> this.firstCharToLower(boGenInfo.getParentEntity())));
            objectMap.put("boParentMap", boParentMap);
            Map tableInfoMap = mainTableInfos.stream().collect(Collectors.toMap(TableInfo::getName, Function.identity()));
            ArrayList dealEntityCodes = new ArrayList();
            mainTableInfos.stream().filter(tableInfo -> boParentMap.containsKey(tableInfo.getName())).forEach(tableInfo -> {
                dealEntityCodes.add(tableInfo.getName());
                List<TableField> parentFields = this.getParentFields((TableInfo)tableInfoMap.get(boParentMap.get(tableInfo.getName())), dealEntityCodes, boParentMap, tableInfoMap);
                tableInfo.getFields().addAll(parentFields);
            });
            Map boGenInfoMap = mainBoGenInfos.stream().collect(Collectors.toMap(BoGenInfo::getCode, Function.identity()));
            ArrayList dealRelCodes = new ArrayList();
            boGenInfos.stream().filter(boGenInfo -> boParentMap.containsKey(boGenInfo.getCode())).forEach(boGenInfo -> {
                dealRelCodes.add(boGenInfo.getCode());
                List<BoRelInfo> parentRels = this.getParentRels((BoGenInfo)boGenInfoMap.get(boParentMap.get(boGenInfo.getCode())), dealRelCodes, boParentMap, boGenInfoMap);
                boGenInfo.getBoRelLists().addAll(parentRels);
            });
            objectMap.put("boRelMap", mainBoGenInfos.stream().filter(boGenInfo -> CollectionUtils.isNotEmpty((Collection)boGenInfo.getBoRelLists())).collect(Collectors.toMap(BoGenInfo::getCode, BoGenInfo::getBoRelLists)));
            HashMap relBoMap = Maps.newHashMap();
            mainBoGenInfos.forEach(boGenInfo -> {
                HashMap relTableInfoMap = Maps.newHashMap();
                boGenInfo.getBoRelLists().forEach(boRelInfo -> relTableInfoMap.put(boRelInfo.getRelCode(), tableInfoMap.get(boRelInfo.getCode())));
                relBoMap.put(boGenInfo.getCode(), relTableInfoMap);
            });
            objectMap.put("relBoMap", relBoMap);
            objectMap.put("tBoRelMap", tBoGenInfos.stream().filter(boGenInfo -> CollectionUtils.isNotEmpty((Collection)boGenInfo.getBoRelLists())).collect(Collectors.toMap(BoGenInfo::getRemark, BoGenInfo::getBoRelLists)));
            HashMap tRelBoMap = Maps.newHashMap();
            tBoGenInfos.forEach(boGenInfo -> {
                HashMap relTableInfoMap = Maps.newHashMap();
                boGenInfo.getBoRelLists().forEach(boRelInfo -> relTableInfoMap.put(boRelInfo.getRelCode(), tableInfoMap.get(boRelInfo.getCode())));
                tRelBoMap.put(boGenInfo.getRemark(), relTableInfoMap);
            });
            objectMap.put("tRelBoMap", tRelBoMap);
            objectMap.put("tTableCodeMap", tTableInfos.stream().collect(Collectors.groupingBy(TableInfo::getName)));
            objectMap.put("tTableTenantMap", tTableInfos.stream().collect(Collectors.toMap(TableInfo::getComment, t -> GenFormatUtils.toUpperCamel((String)t.getComment().split("-")[2]))));
        }
        if (CollectionUtils.isNotEmpty(dictGenInfos)) {
            objectMap.put((String)"dicts", dictGenInfos);
        }
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    private List<TableField> getParentFields(TableInfo tableInfo, List<String> dealEntityCodes, Map<String, String> boParentMap, Map<String, TableInfo> tableInfoMap) {
        List<TableField> parentFields = tableInfo.getFields().stream().filter(tableField -> !this.systemFieldCodes.contains(tableField.getName())).collect(Collectors.toList());
        if (dealEntityCodes.contains(tableInfo.getName())) {
            return parentFields;
        }
        if (boParentMap.containsKey(tableInfo.getName())) {
            parentFields.addAll(this.getParentFields(tableInfoMap.get(boParentMap.get(tableInfo.getName())), dealEntityCodes, boParentMap, tableInfoMap));
        }
        return parentFields;
    }

    private List<BoRelInfo> getParentRels(BoGenInfo boGenInfo, List<String> dealRelCodes, Map<String, String> boParentMap, Map<String, BoGenInfo> boGenInfoMap) {
        List parentRels = boGenInfo.getBoRelLists();
        if (dealRelCodes.contains(boGenInfo.getCode())) {
            return parentRels;
        }
        if (boParentMap.containsKey(boGenInfo.getCode())) {
            parentRels.addAll(this.getParentRels(boGenInfoMap.get(boParentMap.get(boGenInfo.getName())), dealRelCodes, boParentMap, boGenInfoMap));
        }
        return parentRels;
    }

    public Map<String, Object> getPfcpMetaObjectMap(List<PageGenInfo> pageGenInfoList, List<FormGenInfo> formGenInfoList) {
        Map objectMap = this.initTemplateParams();
        ForSdkConfigBuilder config = this.getForSdkConfigBuilder();
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put((String)"author", (Object)globalConfig.getAuthor());
        objectMap.put((String)"date", (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        objectMap.put((String)"pages", (Object)(pageGenInfoList == null ? new ArrayList() : pageGenInfoList));
        objectMap.put((String)"forms", (Object)(formGenInfoList == null ? new ArrayList() : formGenInfoList));
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    private String getMetadataPath() {
        String packageName = String.format("ultraman.%s.%s-metadata", this.forSdkConfigBuilder.getModuleConfig().getName(), this.forSdkConfigBuilder.getModuleConfig().getName());
        String parentDir = this.forSdkConfigBuilder.getGlobalConfig().getOutputDir();
        if (StringUtils.isEmpty((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((CharSequence)parentDir, (CharSequence)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private String joinPath(String packageName) {
        packageName = String.format("ultraman.%s.%s-metadata.src.main.java.%s.metadata.%s", this.forSdkConfigBuilder.getModuleConfig().getName(), this.forSdkConfigBuilder.getModuleConfig().getName(), this.forSdkConfigBuilder.getPackageConfig().getParent(), packageName);
        String parentDir = this.forSdkConfigBuilder.getGlobalConfig().getOutputDir();
        if (StringUtils.isEmpty((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((CharSequence)parentDir, (CharSequence)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private String firstCharToLower(String rawString) {
        return this.prefixToLower(rawString, 1);
    }

    private String prefixToLower(String rawString, int index) {
        String beforeChar = rawString.substring(0, index).toLowerCase();
        String afterChar = rawString.substring(index);
        return beforeChar + afterChar;
    }
}

