/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.xforceplus.ultraman.bocp.gen.config.ForSdkConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.po.BoGenField;
import com.xforceplus.ultraman.bocp.gen.po.BoGenInfo;
import com.xforceplus.ultraman.bocp.gen.po.DictGenInfo;
import com.xforceplus.ultraman.bocp.gen.po.DtoGenInfo;
import com.xforceplus.ultraman.bocp.gen.util.GenFormatUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForSdkVelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(ForSdkVelocityTemplateEngine.class);
    public static final String METADATA_POM = "/templates/metadata-pom.xml";
    public static final String BASE_ENTITY_PATH = "/templates/BaseEntity.java";
    public static final String ENTITY_PATH = "/templates/Entity.java";
    public static final String DTO_PATH = "/templates/Dto.java";
    public static final String ENUM_PATH = "/templates/Enum.java";
    public static final String DOT_VM = ".vm";
    protected VelocityEngine velocityEngine;
    protected ForSdkConfigBuilder forSdkConfigBuilder;

    public ForSdkVelocityTemplateEngine init(ForSdkConfigBuilder forSdkConfigBuilder) {
        this.forSdkConfigBuilder = forSdkConfigBuilder;
        if (null == this.velocityEngine) {
            Properties p = new Properties();
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("resource.loader.file.path", "");
            p.setProperty("UTF-8", ConstVal.UTF8);
            p.setProperty("resource.default_encoding", ConstVal.UTF8);
            p.setProperty("file.resource.loader.unicode", "true");
            this.velocityEngine = new VelocityEngine(p);
        }
        return this;
    }

    public void writer(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        if (StringUtils.isEmpty((CharSequence)templatePath)) {
            return;
        }
        Template template = this.velocityEngine.getTemplate(templatePath, ConstVal.UTF8);
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fos, ConstVal.UTF8);
             BufferedWriter writer = new BufferedWriter(ow);){
            template.merge((Context)new VelocityContext(objectMap), (Writer)writer);
        }
        logger.info("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
        System.out.println("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
    }

    public String templateFilePath(String filePath) {
        if (null == filePath || filePath.contains(DOT_VM)) {
            return filePath;
        }
        return filePath + DOT_VM;
    }

    public ForSdkVelocityTemplateEngine mkdirs(String value) {
        boolean result;
        File dir = new File(value);
        if (!dir.exists() && (result = dir.mkdirs())) {
            logger.debug("\u521b\u5efa\u76ee\u5f55\uff1a [" + value + "]");
        }
        return this;
    }

    public ForSdkVelocityTemplateEngine mkdirs() {
        this.getForSdkConfigBuilder().getPathInfo().forEach((key, value) -> {
            boolean result;
            File dir = new File((String)value);
            if (!dir.exists() && (result = dir.mkdirs())) {
                logger.debug("\u521b\u5efa\u76ee\u5f55\uff1a [" + value + "]");
            }
        });
        return this;
    }

    public void open() {
        String outDir = this.getForSdkConfigBuilder().getGlobalConfig().getOutputDir();
        if (this.getForSdkConfigBuilder().getGlobalConfig().isOpen() && StringUtils.isNotEmpty((CharSequence)outDir)) {
            try {
                String osName = System.getProperty("os.name");
                if (osName != null) {
                    if (osName.contains("Mac")) {
                        Runtime.getRuntime().exec("open " + outDir);
                    } else if (osName.contains("Windows")) {
                        Runtime.getRuntime().exec("cmd /c start " + outDir);
                    } else {
                        logger.debug("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + outDir);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String getSuperClassName(String classPath) {
        if (StringUtils.isEmpty((CharSequence)classPath)) {
            return null;
        }
        return classPath.substring(classPath.lastIndexOf(".") + 1);
    }

    protected String suffixJavaOrKt() {
        return this.getForSdkConfigBuilder().getGlobalConfig().isKotlin() ? ".kt" : ".java";
    }

    public ForSdkConfigBuilder getForSdkConfigBuilder() {
        return this.forSdkConfigBuilder;
    }

    public void setForSdkConfigBuilder(ForSdkConfigBuilder forSdkConfigBuilder) {
        this.forSdkConfigBuilder = forSdkConfigBuilder;
    }

    protected Map<String, Object> initTemplateParams() {
        HashMap<String, Object> objectMap = new HashMap<String, Object>(30);
        ForSdkConfigBuilder config = this.getForSdkConfigBuilder();
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("config", config);
        objectMap.put("application", config.getApplicationConfig());
        objectMap.put("project", config.getProjectConfig());
        objectMap.put("package", config.getPackageInfo());
        objectMap.put("module", config.getModuleConfig());
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("enableCache", globalConfig.isEnableCache());
        objectMap.put("packageentity", config.getPackageConfig().getParent() + ".metadata.entity");
        objectMap.put("packagedto", config.getPackageConfig().getParent() + ".metadata.dto");
        objectMap.put("packagedict", config.getPackageConfig().getParent() + ".metadata.dict");
        objectMap.put("packagemeta", config.getPackageConfig().getParent() + ".metadata.meta");
        objectMap.put("packagemeta", config.getPackageConfig().getParent() + ".metadata.meta");
        objectMap.put("packagevalidator", config.getPackageConfig().getParent() + ".metadata.validator");
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        return objectMap;
    }

    public ForSdkVelocityTemplateEngine batchOutput() {
        this.mkdirs(this.getMetadataPath());
        this.mkdirs(this.joinPath("entity"));
        this.mkdirs(this.joinPath("dto"));
        this.mkdirs(this.joinPath("dict"));
        try {
            Map<String, Object> objectMap = this.getObjectMap();
            String domainPomFile = String.format(this.getMetadataPath() + File.separator + "%s" + ".xml", "pom");
            this.writer(objectMap, this.templateFilePath(METADATA_POM), domainPomFile);
            if (this.getForSdkConfigBuilder().getStrategyConfig().getSuperEntityClass() != null && this.getForSdkConfigBuilder().getBoConfig().getBaseEntity() != null) {
                TableInfo baseEntity = this.getForSdkConfigBuilder().getBaseEntity();
                baseEntity.setCommonFields(new ArrayList());
                String baseEntityFile = String.format(this.joinPath("entity") + File.separator + "%s" + this.suffixJavaOrKt(), baseEntity.getEntityName());
                this.writer(this.getObjectMap(baseEntity, null, null), this.templateFilePath(BASE_ENTITY_PATH), baseEntityFile);
            }
            List<TableInfo> tableInfoList = this.getForSdkConfigBuilder().getTableInfoList();
            List boGenInfoList = this.getForSdkConfigBuilder().getBoConfig().getBoGenInfoList();
            for (TableInfo tableInfo : tableInfoList) {
                BoGenInfo boGenInfo = boGenInfoList.stream().filter(bGenInfo -> bGenInfo.getCode().equals(tableInfo.getName())).findAny().orElse(null);
                objectMap = this.getObjectMap(tableInfo, boGenInfo, tableInfoList);
                String entityName = tableInfo.getEntityName();
                String entityFile = String.format(this.joinPath("entity") + File.separator + "%s" + this.suffixJavaOrKt(), entityName);
                this.writer(objectMap, this.templateFilePath(ENTITY_PATH), entityFile);
            }
            if (this.getForSdkConfigBuilder().getDtoConfig() != null && this.getForSdkConfigBuilder().getDtoConfig().getDtoGenInfos() != null) {
                List dtoGenInfoList = this.getForSdkConfigBuilder().getDtoConfig().getDtoGenInfos();
                for (DtoGenInfo dtoGenInfo : dtoGenInfoList) {
                    objectMap = this.getDtoObjectMap(dtoGenInfo);
                    String dtoName = StringUtils.capitalize((String)dtoGenInfo.getCode());
                    String dtoFile = String.format(this.joinPath("dto") + File.separator + "%s" + this.suffixJavaOrKt(), dtoName);
                    this.writer(objectMap, this.templateFilePath(DTO_PATH), dtoFile);
                }
            }
            List dictGenInfos = this.getForSdkConfigBuilder().getDictConfig().getDictGenInfos();
            for (DictGenInfo dictGenInfo : dictGenInfos) {
                objectMap = this.getDictObjectMap(dictGenInfo);
                String entityFile = String.format(this.joinPath("dict") + File.separator + "%s" + this.suffixJavaOrKt(), dictGenInfo.getCode());
                this.writer(objectMap, this.templateFilePath(ENUM_PATH), entityFile);
            }
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
        }
        return this;
    }

    public Map<String, Object> getObjectMap() {
        Map objectMap = this.initTemplateParams();
        ForSdkConfigBuilder config = this.getForSdkConfigBuilder();
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    public Map<String, Object> getObjectMap(TableInfo tableInfo, BoGenInfo boGenInfo, List<TableInfo> tableInfos) {
        Map objectMap = this.initTemplateParams();
        ForSdkConfigBuilder config = this.getForSdkConfigBuilder();
        objectMap.put((String)"entityname", (Object)this.firstToLowerCase(tableInfo.getEntityName()));
        objectMap.put((String)"entity", (Object)tableInfo.getEntityName());
        objectMap.put((String)"entityId", (Object)boGenInfo.getId());
        objectMap.put((String)"table", (Object)tableInfo);
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put((String)"author", (Object)globalConfig.getAuthor());
        objectMap.put((String)"idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put((String)"logicDeleteFieldName", (Object)config.getStrategyConfig().getLogicDeleteFieldName());
        objectMap.put((String)"versionFieldName", (Object)config.getStrategyConfig().getVersionFieldName());
        objectMap.put((String)"activeRecord", globalConfig.isActiveRecord());
        objectMap.put((String)"kotlin", globalConfig.isKotlin());
        objectMap.put((String)"swagger2", globalConfig.isSwagger2());
        objectMap.put((String)"date", (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        objectMap.put((String)"enableCache", globalConfig.isEnableCache());
        objectMap.put((String)"baseResultMap", globalConfig.isBaseResultMap());
        objectMap.put((String)"baseColumnList", globalConfig.isBaseColumnList());
        objectMap.put((String)"entitySerialVersionUID", config.getStrategyConfig().isEntitySerialVersionUID());
        objectMap.put((String)"entityColumnConstant", config.getStrategyConfig().isEntityColumnConstant());
        objectMap.put((String)"entityBuilderModel", config.getStrategyConfig().isEntityBuilderModel());
        objectMap.put((String)"entityLombokModel", config.getStrategyConfig().isEntityLombokModel());
        objectMap.put((String)"entityBooleanColumnRemoveIsPrefix", config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix());
        objectMap.put((String)"superEntityClass", (Object)this.getSuperClassName(config.getSuperEntityClass()));
        objectMap.put((String)"formatUtils", GenFormatUtils.class);
        if (boGenInfo != null) {
            List enumTypes = boGenInfo.getBoGenFieldList().stream().filter(field -> field.isEnum()).map(BoGenField::getFieldType).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(enumTypes)) {
                objectMap.put("hasEnumType", true);
                objectMap.put("enumTypes", enumTypes);
            }
            if (!StringUtils.isEmpty((CharSequence)boGenInfo.getParentEntity())) {
                objectMap.put("hasParent", true);
                objectMap.put("parentEntity", boGenInfo.getParentEntity());
                if (tableInfos != null) {
                    tableInfos.stream().filter(table -> table.getEntityName().equals(boGenInfo.getParentEntity())).findAny().ifPresent(table -> {
                        List childFields = tableInfo.getFields().stream().map(TableField::getPropertyName).collect(Collectors.toList());
                        List fields = table.getFields().stream().filter(field -> !childFields.contains(field.getPropertyName())).collect(Collectors.toList());
                        objectMap.put("parentFields", fields);
                    });
                }
            }
            objectMap.put("boRefs", boGenInfo.getBoRelLists());
        }
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    public Map<String, Object> getDtoObjectMap(DtoGenInfo dtoGenInfo) {
        Map objectMap = this.initTemplateParams();
        ForSdkConfigBuilder config = this.getForSdkConfigBuilder();
        objectMap.put((String)"dtoname", (Object)StringUtils.capitalize((String)dtoGenInfo.getCode()));
        objectMap.put((String)"dtoInfo", (Object)dtoGenInfo);
        objectMap.put((String)"dto", (Object)dtoGenInfo.getCode());
        objectMap.put((String)"dtoSerialVersionUID", config.getStrategyConfig().isEntitySerialVersionUID());
        objectMap.put((String)"dtoColumnConstant", config.getStrategyConfig().isEntityColumnConstant());
        objectMap.put((String)"dtoBuilderModel", config.getStrategyConfig().isEntityBuilderModel());
        objectMap.put((String)"dtoLombokModel", config.getStrategyConfig().isEntityLombokModel());
        objectMap.put((String)"dtoBooleanColumnRemoveIsPrefix", config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix());
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    public Map<String, Object> getDictObjectMap(DictGenInfo dictGenInfo) {
        Map objectMap = this.initTemplateParams();
        ForSdkConfigBuilder config = this.getForSdkConfigBuilder();
        objectMap.put((String)"dict", (Object)dictGenInfo);
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    private String getMetadataPath() {
        String packageName = String.format("ultraman.%s.%s-metadata", this.forSdkConfigBuilder.getModuleConfig().getName(), this.forSdkConfigBuilder.getModuleConfig().getName());
        String parentDir = this.forSdkConfigBuilder.getGlobalConfig().getOutputDir();
        if (StringUtils.isEmpty((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((CharSequence)parentDir, (CharSequence)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private String joinPath(String packageName) {
        packageName = String.format("ultraman.%s.%s-metadata.src.main.java.%s.metadata.%s", this.forSdkConfigBuilder.getModuleConfig().getName(), this.forSdkConfigBuilder.getModuleConfig().getName(), this.forSdkConfigBuilder.getPackageConfig().getParent(), packageName);
        String parentDir = this.forSdkConfigBuilder.getGlobalConfig().getOutputDir();
        if (StringUtils.isEmpty((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((CharSequence)parentDir, (CharSequence)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private String firstToLowerCase(String param) {
        return StringUtils.isBlank((CharSequence)param) ? "" : param.substring(0, 1).toLowerCase() + param.substring(1);
    }
}

