/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.tools.service.factory;

import com.xforceplus.ultraman.test.tools.service.mail.adapt.MailStrategy;
import com.xforceplus.ultraman.test.tools.service.mail.enums.MailType;
import java.util.HashMap;
import java.util.Map;

public class MailFactory {
    private Map<String, MailStrategy> strategiesInstances = new HashMap<String, MailStrategy>();

    @SafeVarargs
    public <T extends MailStrategy> MailFactory(T ... strategies) {
        for (T strategy : strategies) {
            for (MailType m : MailType.values()) {
                if (!m.klass().equals(strategy.getClass())) continue;
                this.strategiesInstances.put(m.format(), (MailStrategy)strategy);
            }
        }
    }

    public MailStrategy mailStrategy(String type) {
        return this.strategiesInstances.get(type);
    }
}

