/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.tools.service.mail.adapt;

import com.xforceplus.ultraman.test.tools.service.mail.adapt.MailStrategy;
import com.xforceplus.ultraman.test.tools.service.mail.entity.MailEntity;
import java.util.Locale;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Component
public class TemplateStrategy
implements MailStrategy {
    private static final Logger LOG = LogManager.getLogger(TemplateStrategy.class);
    @Autowired
    private JavaMailSender javaMailSender;
    @Autowired
    private TemplateEngine templateEngine;

    @Override
    public boolean send(MailEntity mailEntity) {
        String content = this.toTemplateContent(mailEntity.getTemplateName(), mailEntity.getParams());
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper message = new MimeMessageHelper(mimeMessage, "UTF-8");
        try {
            message.setFrom(mailEntity.getFrom());
            message.setTo(mailEntity.getTo());
            message.setSubject(mailEntity.getTitle());
            message.setText(content, true);
            this.javaMailSender.send(mimeMessage);
            LOG.info("\u6a21\u677f\u90ae\u4ef6\u5df2\u7ecf\u53d1\u9001-[{}].", (Object)mailEntity.getTo());
            return true;
        }
        catch (MessagingException e) {
            e.printStackTrace();
            LOG.error("\u53d1\u9001\u6a21\u677f\u90ae\u4ef6[{}]\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Object)mailEntity.getTemplateName());
            return false;
        }
    }

    private String toTemplateContent(String template, Map<String, Object> templateParams) {
        Context context = new Context(new Locale(""));
        if (null != templateParams && !templateParams.isEmpty()) {
            context.setVariables(templateParams);
        }
        return this.templateEngine.process(template, (IContext)context);
    }
}

