/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.test.tools.service.mail.sender;

import com.xforceplus.ultraman.test.tools.service.factory.MailFactory;
import com.xforceplus.ultraman.test.tools.service.mail.adapt.MailStrategy;
import com.xforceplus.ultraman.test.tools.service.mail.entity.MailEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MailSenderBox {
    private static final Logger LOG = LogManager.getLogger(MailSenderBox.class);
    @Value(value="${spring.mail.username}")
    private String sender;
    @Autowired
    private MailFactory mailFactory;

    public boolean sendMail(MailEntity mail) {
        mail.resetFrom(this.sender);
        MailStrategy mailStrategy = this.mailFactory.mailStrategy(mail.getContentType());
        if (null == mailStrategy) {
            LOG.warn("unSupport-mailStrategy {}, ", (Object)mail.getContentType());
            return false;
        }
        return mailStrategy.send(mail);
    }
}

