package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetAccountCompanyListRequest;
import com.xforceplus.ucenter.client.model.MsGetAccountCompanyListResponse;
import com.xforceplus.ucenter.client.model.MsGetAccountDetailRequest;
import com.xforceplus.ucenter.client.model.MsGetAccountDetailResponse;
import com.xforceplus.ucenter.client.model.MsGetAccountListRequest;
import com.xforceplus.ucenter.client.model.MsGetAccountListResponse;
import com.xforceplus.ucenter.client.model.MsOperateAccountRequest;
import com.xforceplus.ucenter.client.model.MsOperateAccountResponse;
import com.xforceplus.ucenter.client.model.MsSetAccountPasswordRequest;
import com.xforceplus.ucenter.client.model.MsSetAccountPasswordResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "account", description = "the account API")
public interface AccountApi {

    @ApiOperation(value = "获取账户信息", notes = "", response = MsGetAccountDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "account", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetAccountDetailResponse.class) })
    @RequestMapping(value = "/account/getAccountDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetAccountDetailResponse getAccountDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetAccountDetailRequest request);


    @ApiOperation(value = "获取账户列表", notes = "", response = MsGetAccountListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "account", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetAccountListResponse.class) })
    @RequestMapping(value = "/account/getAccountList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetAccountListResponse getAccountList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetAccountListRequest request);


    @ApiOperation(value = "获取公司列表", notes = "", response = MsGetAccountCompanyListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "account", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetAccountCompanyListResponse.class) })
    @RequestMapping(value = "/account/getCompanyList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetAccountCompanyListResponse getCompanyList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetAccountCompanyListRequest request);


    @ApiOperation(value = "操作账户信息", notes = "", response = MsOperateAccountResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "account", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateAccountResponse.class) })
    @RequestMapping(value = "/account/operateTenant",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateAccountResponse operateAccount(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateAccountRequest request);


    @ApiOperation(value = "设置账户密码", notes = "", response = MsSetAccountPasswordResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "account", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsSetAccountPasswordResponse.class) })
    @RequestMapping(value = "/account/setAccountPassword",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsSetAccountPasswordResponse setAccountPassword(@ApiParam(value = "request" ,required=true ) @RequestBody MsSetAccountPasswordRequest request);

}
