package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetTenantIdentiRequest;
import com.xforceplus.ucenter.client.model.MsGetTenantIdentiResponse;
import com.xforceplus.ucenter.client.model.MsOperateTenantIdentiRequest;
import com.xforceplus.ucenter.client.model.MsOperateTenantIdentiResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "groupIdenti", description = "the groupIdenti API")
public interface GroupIdentiApi {

    @ApiOperation(value = "获取集团标识", notes = "", response = MsGetTenantIdentiResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "tenantIdenti", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetTenantIdentiResponse.class) })
    @RequestMapping(value = "/groupIdenti/getTenantIdenti",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetTenantIdentiResponse getTenantIdenti(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetTenantIdentiRequest request);


    @ApiOperation(value = "集团标识操作", notes = "", response = MsOperateTenantIdentiResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "tenantIdenti", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateTenantIdentiResponse.class) })
    @RequestMapping(value = "/groupIdenti/operateTenantIdenti",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateTenantIdentiResponse operateTenantIdenti(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateTenantIdentiRequest request);

}
