package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsCheckMenuNameRequest;
import com.xforceplus.ucenter.client.model.MsCheckMenuNameResponse;
import com.xforceplus.ucenter.client.model.MsGetMenuDetailRequest;
import com.xforceplus.ucenter.client.model.MsGetMenuDetailResponse;
import com.xforceplus.ucenter.client.model.MsGetMenuInfoListRequest;
import com.xforceplus.ucenter.client.model.MsGetMenuInfoListResponse;
import com.xforceplus.ucenter.client.model.MsGetMenuListRequest;
import com.xforceplus.ucenter.client.model.MsGetMenuListResponse;
import com.xforceplus.ucenter.client.model.MsGetMenuResourceListByUserRequest;
import com.xforceplus.ucenter.client.model.MsGetMenuResourceListByUserResponse;
import com.xforceplus.ucenter.client.model.MsOperateMenuRequest;
import com.xforceplus.ucenter.client.model.MsOperateMenuResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "menu", description = "the menu API")
public interface MenuApi {

    @ApiOperation(value = "验证菜单名称", notes = "", response = MsCheckMenuNameResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsCheckMenuNameResponse.class) })
    @RequestMapping(value = "/menu/checkName",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsCheckMenuNameResponse checkName(@ApiParam(value = "request" ,required=true ) @RequestBody MsCheckMenuNameRequest request);


    @ApiOperation(value = "获取菜单信息", notes = "", response = MsGetMenuDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetMenuDetailResponse.class) })
    @RequestMapping(value = "/menu/getMenuDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetMenuDetailResponse getMenuDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetMenuDetailRequest request);


    @ApiOperation(value = "获取菜单记录列表", notes = "", response = MsGetMenuInfoListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetMenuInfoListResponse.class) })
    @RequestMapping(value = "/menu/getMenuInfoList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetMenuInfoListResponse getMenuInfoList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetMenuInfoListRequest request);


    @ApiOperation(value = "获取菜单列表", notes = "", response = MsGetMenuListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetMenuListResponse.class) })
    @RequestMapping(value = "/menu/getMenuList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetMenuListResponse getMenuList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetMenuListRequest request);


    @ApiOperation(value = "获取用户菜单资源码列表", notes = "", response = MsGetMenuResourceListByUserResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetMenuResourceListByUserResponse.class) })
    @RequestMapping(value = "/menu/getMenuResourceListByUser",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetMenuResourceListByUserResponse getMenuResourceListByUser(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetMenuResourceListByUserRequest request);


    @ApiOperation(value = "操作菜单信息", notes = "", response = MsOperateMenuResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "menu", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateMenuResponse.class) })
    @RequestMapping(value = "/menu/operateMenu",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateMenuResponse operateMenu(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateMenuRequest request);

}
