package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetOrgUserRelListRequest;
import com.xforceplus.ucenter.client.model.MsGetOrgUserRelListResponse;
import com.xforceplus.ucenter.client.model.MsOperateOrgUserRelRequest;
import com.xforceplus.ucenter.client.model.MsOperateOrgUserRelResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "orgUserRel", description = "the orgUserRel API")
public interface OrgUserRelApi {

    @ApiOperation(value = "获取人员的组织列表", notes = "", response = MsGetOrgUserRelListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "orgUserRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetOrgUserRelListResponse.class) })
    @RequestMapping(value = "/orgUserRel/getOrgUserRelList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetOrgUserRelListResponse getOrgUserRelList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetOrgUserRelListRequest request);


    @ApiOperation(value = "人员与组织关联操作", notes = "", response = MsOperateOrgUserRelResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "orgUserRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateOrgUserRelResponse.class) })
    @RequestMapping(value = "/orgUserRel/operateOrgUserRel",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateOrgUserRelResponse operateOrgUserRel(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateOrgUserRelRequest request);

}
