package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetOrgStructDetailRequest;
import com.xforceplus.ucenter.client.model.MsGetOrgStructDetailResponse;
import com.xforceplus.ucenter.client.model.MsGetOrgStructListRequest;
import com.xforceplus.ucenter.client.model.MsGetOrgStructListResponse;
import com.xforceplus.ucenter.client.model.MsGetOrgStructTreeRequest;
import com.xforceplus.ucenter.client.model.MsGetOrgStructTreeResponse;
import com.xforceplus.ucenter.client.model.MsGetOrgSubListRequest;
import com.xforceplus.ucenter.client.model.MsGetOrgSubListResponse;
import com.xforceplus.ucenter.client.model.MsGetUserOrgStructListRequest;
import com.xforceplus.ucenter.client.model.MsGetUserOrgStructListResponse;
import com.xforceplus.ucenter.client.model.MsOperateOrgStructRequest;
import com.xforceplus.ucenter.client.model.MsOperateOrgStructResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "orgstruct", description = "the orgstruct API")
public interface OrgstructApi {

    @ApiOperation(value = "获取组织架构信息", notes = "", response = MsGetOrgStructDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysOrgStruct", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetOrgStructDetailResponse.class) })
    @RequestMapping(value = "/orgstruct/getOrgStructDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetOrgStructDetailResponse getOrgStructDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetOrgStructDetailRequest request);


    @ApiOperation(value = "获取组织架构列表", notes = "", response = MsGetOrgStructListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysOrgStruct", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetOrgStructListResponse.class) })
    @RequestMapping(value = "/orgstruct/getOrgStructList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetOrgStructListResponse getOrgStructList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetOrgStructListRequest request);


    @ApiOperation(value = "获取组织架构树", notes = "", response = MsGetOrgStructTreeResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysOrgStruct", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetOrgStructTreeResponse.class) })
    @RequestMapping(value = "/orgstruct/orgTree",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetOrgStructTreeResponse getOrgStructTree(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetOrgStructTreeRequest request);


    @ApiOperation(value = "获取组织架构子集合", notes = "", response = MsGetOrgSubListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysOrgStruct", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetOrgSubListResponse.class) })
    @RequestMapping(value = "/orgstruct/orgSubList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetOrgSubListResponse getOrgSubList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetOrgSubListRequest request);


    @ApiOperation(value = "获取用户组织架构列表", notes = "", response = MsGetUserOrgStructListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysUserOrgStruct", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetUserOrgStructListResponse.class) })
    @RequestMapping(value = "/orgstruct/getUserOrgStructList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetUserOrgStructListResponse getUserOrgStructList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetUserOrgStructListRequest request);


    @ApiOperation(value = "操作组织架构", notes = "", response = MsOperateOrgStructResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysOrgStruct", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateOrgStructResponse.class) })
    @RequestMapping(value = "/orgstruct/operateOrgStruct",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateOrgStructResponse operateOrgStruct(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateOrgStructRequest request);


    @ApiOperation(value = "操作组织架构", notes = "", response = MsOperateOrgStructResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysOrgStruct", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateOrgStructResponse.class) })
    @RequestMapping(value = "/orgstruct/batchUpdatePids",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateOrgStructResponse operateOrgStruct();

}
