package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetResourceApiRelDetailRequest;
import com.xforceplus.ucenter.client.model.MsGetResourceApiRelDetailResponse;
import com.xforceplus.ucenter.client.model.MsGetResourceApiRelListRequest;
import com.xforceplus.ucenter.client.model.MsGetResourceApiRelListResponse;
import com.xforceplus.ucenter.client.model.MsOperateResourceApiRelRequest;
import com.xforceplus.ucenter.client.model.MsOperateResourceApiRelResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "resourceApiRel", description = "the resourceApiRel API")
public interface ResourceApiRelApi {

    @ApiOperation(value = "获取资源码-Api信息", notes = "", response = MsGetResourceApiRelDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResourceApiRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetResourceApiRelDetailResponse.class) })
    @RequestMapping(value = "/resourceApiRel/getResourceApiRelDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetResourceApiRelDetailResponse getResourceApiRelDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetResourceApiRelDetailRequest request);


    @ApiOperation(value = "获取资源码-Api列表", notes = "", response = MsGetResourceApiRelListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResourceApiRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetResourceApiRelListResponse.class) })
    @RequestMapping(value = "/resourceApiRel/getResourceApiRelList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetResourceApiRelListResponse getResourceApiRelList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetResourceApiRelListRequest request);


    @ApiOperation(value = "操作资源码-Api", notes = "", response = MsOperateResourceApiRelResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResourceApiRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateResourceApiRelResponse.class) })
    @RequestMapping(value = "/resourceApiRel/operateResourceApiRel",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateResourceApiRelResponse operateResourceApiRel(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateResourceApiRelRequest request);

}
