package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetResourcesetDetailRequest;
import com.xforceplus.ucenter.client.model.MsGetResourcesetDetailResponse;
import com.xforceplus.ucenter.client.model.MsGetResourcesetListRequest;
import com.xforceplus.ucenter.client.model.MsGetResourcesetListResponse;
import com.xforceplus.ucenter.client.model.MsOperateResourcesetRequest;
import com.xforceplus.ucenter.client.model.MsOperateResourcesetResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "resourceset", description = "the resourceset API")
public interface ResourcesetApi {

    @ApiOperation(value = "获取功能集信息", notes = "", response = MsGetResourcesetDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResourceset", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetResourcesetDetailResponse.class) })
    @RequestMapping(value = "/resourceset/getResourcesetDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetResourcesetDetailResponse getResourcesetDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetResourcesetDetailRequest request);


    @ApiOperation(value = "获取功能集列表", notes = "", response = MsGetResourcesetListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResourceset", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetResourcesetListResponse.class) })
    @RequestMapping(value = "/resourceset/getResourcesetList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetResourcesetListResponse getResourcesetList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetResourcesetListRequest request);


    @ApiOperation(value = "操作功能集", notes = "", response = MsOperateResourcesetResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResourceset", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateResourcesetResponse.class) })
    @RequestMapping(value = "/resourceset/operateResourceset",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateResourcesetResponse operateResourceset(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateResourcesetRequest request);

}
