package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetResourceListByResourcesetIdRequest;
import com.xforceplus.ucenter.client.model.MsGetResourceListByResourcesetIdResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "resourcesetResourceRel", description = "the resourcesetResourceRel API")
public interface ResourcesetResourceRelApi {

    @ApiOperation(value = "根据功能集id获取资源码列表", notes = "", response = MsGetResourceListByResourcesetIdResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysResourcesetResourceRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetResourceListByResourcesetIdResponse.class) })
    @RequestMapping(value = "/resourcesetResourceRel/getResourceListByResourcesetId",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetResourceListByResourcesetIdResponse getResourceListByResourcesetId(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetResourceListByResourcesetIdRequest request);

}
