package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetRoleDetailRequest;
import com.xforceplus.ucenter.client.model.MsGetRoleDetailResponse;
import com.xforceplus.ucenter.client.model.MsGetRoleListRequest;
import com.xforceplus.ucenter.client.model.MsGetRoleListResponse;
import com.xforceplus.ucenter.client.model.MsOperateRoleRequest;
import com.xforceplus.ucenter.client.model.MsOperateRoleResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "role", description = "the role API")
public interface RoleApi {

    @ApiOperation(value = "获取角色信息", notes = "", response = MsGetRoleDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "role", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetRoleDetailResponse.class) })
    @RequestMapping(value = "/role/getRoleDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetRoleDetailResponse getRoleDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetRoleDetailRequest request);


    @ApiOperation(value = "获取角色列表", notes = "", response = MsGetRoleListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "role", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetRoleListResponse.class) })
    @RequestMapping(value = "/role/getRoleList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetRoleListResponse getRoleList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetRoleListRequest request);


    @ApiOperation(value = "操作角色信息", notes = "", response = MsOperateRoleResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "role", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateRoleResponse.class) })
    @RequestMapping(value = "/role/operateRole",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateRoleResponse operateRole(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateRoleRequest request);

}
