package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetRoleResourcesetRelDetailRequest;
import com.xforceplus.ucenter.client.model.MsGetRoleResourcesetRelDetailResponse;
import com.xforceplus.ucenter.client.model.MsGetRoleResourcesetRelListRequest;
import com.xforceplus.ucenter.client.model.MsGetRoleResourcesetRelListResponse;
import com.xforceplus.ucenter.client.model.MsOperateRoleResourcesetRelRequest;
import com.xforceplus.ucenter.client.model.MsOperateRoleResourcesetRelResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "roleResourcesetRel", description = "the roleResourcesetRel API")
public interface RoleResourcesetRelApi {

    @ApiOperation(value = "获取角色功能集关联信息", notes = "", response = MsGetRoleResourcesetRelDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysRoleResourcesetRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetRoleResourcesetRelDetailResponse.class) })
    @RequestMapping(value = "/roleResourcesetRel/getRoleResourcesetRelDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetRoleResourcesetRelDetailResponse getRoleResourcesetRelDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetRoleResourcesetRelDetailRequest request);


    @ApiOperation(value = "获取角色功能集关联列表", notes = "", response = MsGetRoleResourcesetRelListResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysRoleResourcesetRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetRoleResourcesetRelListResponse.class) })
    @RequestMapping(value = "/roleResourcesetRel/getRoleResourcesetRelList",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetRoleResourcesetRelListResponse getRoleResourcesetRelList(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetRoleResourcesetRelListRequest request);


    @ApiOperation(value = "操作角色功能集关联", notes = "", response = MsOperateRoleResourcesetRelResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SysRoleResourcesetRel", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateRoleResourcesetRelResponse.class) })
    @RequestMapping(value = "/roleResourcesetRel/operateRoleResourcesetRel",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateRoleResourcesetRelResponse operateRoleResourcesetRel(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateRoleResourcesetRelRequest request);

}
