package com.xforceplus.ucenter.client.api;

import com.xforceplus.ucenter.client.model.MsGetSmsValidCodeDetailRequest;
import com.xforceplus.ucenter.client.model.MsGetSmsValidCodeDetailResponse;
import com.xforceplus.ucenter.client.model.MsOperateSmsValidCodeRequest;
import com.xforceplus.ucenter.client.model.MsOperateSmsValidCodeResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "smsvalidcode", description = "the smsvalidcode API")
public interface SmsvalidcodeApi {

    @ApiOperation(value = "获取验证码信息", notes = "", response = MsGetSmsValidCodeDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SmsValidCode", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetSmsValidCodeDetailResponse.class) })
    @RequestMapping(value = "/smsvalidcode/getSmsValidCodeDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetSmsValidCodeDetailResponse getSmsValidCodeDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsGetSmsValidCodeDetailRequest request);


    @ApiOperation(value = "操作验证码", notes = "", response = MsOperateSmsValidCodeResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SmsValidCode", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsOperateSmsValidCodeResponse.class) })
    @RequestMapping(value = "/smsvalidcode/operateSmsValidCode",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsOperateSmsValidCodeResponse operateSmsValidCode(@ApiParam(value = "request" ,required=true ) @RequestBody MsOperateSmsValidCodeRequest request);

}
