package com.xforceplus.ucenter.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsCheckExistsPathRequest {
  @JsonProperty("userId")
  private Long userId = null;

  @JsonProperty("appId")
  private Integer appId = null;

  @JsonProperty("path")
  private String path = null;

  @JsonProperty("requestMethod")
  private String requestMethod = null;

  @JsonIgnore
  public MsCheckExistsPathRequest userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public MsCheckExistsPathRequest appId(Integer appId) {
    this.appId = appId;
    return this;
  }

   /**
   * appId
   * @return appId
  **/
  @ApiModelProperty(value = "appId")
  public Integer getAppId() {
    return appId;
  }

  public void setAppId(Integer appId) {
    this.appId = appId;
  }

  @JsonIgnore
  public MsCheckExistsPathRequest path(String path) {
    this.path = path;
    return this;
  }

   /**
   * path
   * @return path
  **/
  @ApiModelProperty(value = "path")
  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  @JsonIgnore
  public MsCheckExistsPathRequest requestMethod(String requestMethod) {
    this.requestMethod = requestMethod;
    return this;
  }

   /**
   * 请求方法
   * @return requestMethod
  **/
  @ApiModelProperty(value = "请求方法")
  public String getRequestMethod() {
    return requestMethod;
  }

  public void setRequestMethod(String requestMethod) {
    this.requestMethod = requestMethod;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCheckExistsPathRequest checkExistsPathRequest = (MsCheckExistsPathRequest) o;
    return Objects.equals(this.userId, checkExistsPathRequest.userId) &&
        Objects.equals(this.appId, checkExistsPathRequest.appId) &&
        Objects.equals(this.path, checkExistsPathRequest.path) &&
        Objects.equals(this.requestMethod, checkExistsPathRequest.requestMethod);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, appId, path, requestMethod);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCheckExistsPathRequest {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    requestMethod: ").append(toIndentedString(requestMethod)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
